/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.widget;

import android.content.Context;
import android.graphics.Matrix;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewConfiguration;
import android.widget.ImageView;

public class GestureImageView
extends ImageView {
    private static final String TAG = "GestureImageView";
    private ScaleGestureDetector mScaleGesture;
    private Matrix mImageMatrix;
    private GestureDetectorCompat mGestureDetector;
    private static final float MAX_SCALE_FACTOR = 3.0f;
    private static final float MIN_SCALE_FACTOR = 0.3f;
    private int mTouchSlop;
    private float mCurrentFactor = 1.0f;
    private float mFirstPointerX;
    private float mFirstPointerY;
    private float mSecondPointerX;
    private float mSecondPointerY;
    private int mCenterX;
    private int mCenterY;

    public GestureImageView(Context context) {
        super(context);
        this.init(context);
    }

    public GestureImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public GestureImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.mImageMatrix = new Matrix();
        this.mScaleGesture = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                float factor = detector.getScaleFactor();
                GestureImageView.this.mImageMatrix.postScale(factor, factor, (float)GestureImageView.this.mCenterX, (float)GestureImageView.this.mCenterY);
                GestureImageView.this.setImageMatrix(GestureImageView.this.mImageMatrix);
                return true;
            }
        });
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                GestureImageView.this.mImageMatrix.postScale(1.0f, 1.0f, (float)GestureImageView.this.mCenterX, (float)GestureImageView.this.mCenterY);
                GestureImageView.this.setImageMatrix(GestureImageView.this.mImageMatrix);
                return true;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                return true;
            }

            public boolean onDown(MotionEvent e) {
                return true;
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw || h != oldh) {
            int cx = (w - this.getDrawable().getIntrinsicWidth()) / 2;
            int cy = (h - this.getDrawable().getIntrinsicHeight()) / 2;
            this.mImageMatrix.setTranslate((float)cx, (float)cy);
            this.setImageMatrix(this.mImageMatrix);
            this.mCenterX = w / 2;
            this.mCenterY = h / 2;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retValue = this.mScaleGesture.onTouchEvent(event);
        retValue = this.mGestureDetector.onTouchEvent(event) || retValue;
        return retValue || super.onTouchEvent(event);
    }
}

