/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.Scroller;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import me.nereo.multi_image_selector.R;

public class HorizontalListView
extends AdapterView<ListAdapter> {
    private static final int INSERT_AT_END_OF_LIST = -1;
    private static final int INSERT_AT_START_OF_LIST = 0;
    private static final float FLING_DEFAULT_ABSORB_VELOCITY = 30.0f;
    private static final float FLING_FRICTION = 0.009f;
    private static final String BUNDLE_ID_CURRENT_X = "BUNDLE_ID_CURRENT_X";
    private static final String BUNDLE_ID_PARENT_STATE = "BUNDLE_ID_PARENT_STATE";
    protected Scroller mFlingTracker = new Scroller(this.getContext());
    private final GestureListener mGestureListener = new GestureListener();
    private GestureDetector mGestureDetector;
    private int mDisplayOffset;
    protected ListAdapter mAdapter;
    private List<Queue<View>> mRemovedViewsCache = new ArrayList<Queue<View>>();
    private boolean mDataChanged = false;
    private Rect mRect = new Rect();
    private View mViewBeingTouched = null;
    private int mDividerWidth = 0;
    private Drawable mDivider = null;
    protected int mCurrentX;
    protected int mNextX;
    private Integer mRestoreX = null;
    private int mMaxX = Integer.MAX_VALUE;
    private int mLeftViewAdapterIndex;
    private int mRightViewAdapterIndex;
    private int mCurrentlySelectedAdapterIndex;
    private RunningOutOfDataListener mRunningOutOfDataListener = null;
    private int mRunningOutOfDataThreshold = 0;
    private boolean mHasNotifiedRunningLowOnData = false;
    private OnScrollStateChangedListener mOnScrollStateChangedListener = null;
    private OnScrollStateChangedListener.ScrollState mCurrentScrollState = OnScrollStateChangedListener.ScrollState.SCROLL_STATE_IDLE;
    private EdgeEffectCompat mEdgeGlowLeft;
    private EdgeEffectCompat mEdgeGlowRight;
    private int mHeightMeasureSpec;
    private boolean mBlockTouchAction = false;
    private boolean mIsParentVerticiallyScrollableViewDisallowingInterceptTouchEvent = false;
    private View.OnClickListener mOnClickListener;
    private DataSetObserver mAdapterDataObserver = new DataSetObserver(){

        public void onChanged() {
            HorizontalListView.this.mDataChanged = true;
            HorizontalListView.this.mHasNotifiedRunningLowOnData = false;
            HorizontalListView.this.unpressTouchedChild();
            HorizontalListView.this.invalidate();
            HorizontalListView.this.requestLayout();
        }

        public void onInvalidated() {
            HorizontalListView.this.mHasNotifiedRunningLowOnData = false;
            HorizontalListView.this.unpressTouchedChild();
            HorizontalListView.this.reset();
            HorizontalListView.this.invalidate();
            HorizontalListView.this.requestLayout();
        }
    };
    private Runnable mDelayedLayout = new Runnable(){

        @Override
        public void run() {
            HorizontalListView.this.requestLayout();
        }
    };

    public HorizontalListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mEdgeGlowLeft = new EdgeEffectCompat(context);
        this.mEdgeGlowRight = new EdgeEffectCompat(context);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.mGestureListener);
        this.bindGestureDetector();
        this.initView();
        this.retrieveXmlConfiguration(context, attrs);
        this.setWillNotDraw(false);
        if (Build.VERSION.SDK_INT >= 11) {
            HoneycombPlus.setFriction(this.mFlingTracker, 0.009f);
        }
    }

    private void bindGestureDetector() {
        View.OnTouchListener gestureListenerHandler = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return HorizontalListView.this.mGestureDetector.onTouchEvent(event);
            }
        };
        this.setOnTouchListener(gestureListenerHandler);
    }

    private void requestParentListViewToNotInterceptTouchEvents(Boolean disallowIntercept) {
        if (this.mIsParentVerticiallyScrollableViewDisallowingInterceptTouchEvent != disallowIntercept) {
            HorizontalListView view = this;
            while (view.getParent() instanceof View) {
                if (view.getParent() instanceof ListView || view.getParent() instanceof ScrollView) {
                    view.getParent().requestDisallowInterceptTouchEvent(disallowIntercept.booleanValue());
                    this.mIsParentVerticiallyScrollableViewDisallowingInterceptTouchEvent = disallowIntercept;
                    return;
                }
                view = (View)view.getParent();
            }
        }
    }

    private void retrieveXmlConfiguration(Context context, AttributeSet attrs) {
        if (attrs != null) {
            int dividerWidth;
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.HorizontalListView);
            Drawable d = a.getDrawable(R.styleable.HorizontalListView_android_divider);
            if (d != null) {
                this.setDivider(d);
            }
            if ((dividerWidth = a.getDimensionPixelSize(R.styleable.HorizontalListView_dividerWidth, 0)) != 0) {
                this.setDividerWidth(dividerWidth);
            }
            a.recycle();
        }
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(BUNDLE_ID_PARENT_STATE, super.onSaveInstanceState());
        bundle.putInt(BUNDLE_ID_CURRENT_X, this.mCurrentX);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mRestoreX = bundle.getInt(BUNDLE_ID_CURRENT_X);
            super.onRestoreInstanceState(bundle.getParcelable(BUNDLE_ID_PARENT_STATE));
        }
    }

    public void setDivider(Drawable divider) {
        this.mDivider = divider;
        if (divider != null) {
            this.setDividerWidth(divider.getIntrinsicWidth());
        } else {
            this.setDividerWidth(0);
        }
    }

    public void setDividerWidth(int width) {
        this.mDividerWidth = width;
        this.requestLayout();
        this.invalidate();
    }

    private void initView() {
        this.mLeftViewAdapterIndex = -1;
        this.mRightViewAdapterIndex = -1;
        this.mDisplayOffset = 0;
        this.mCurrentX = 0;
        this.mNextX = 0;
        this.mMaxX = Integer.MAX_VALUE;
        this.setCurrentScrollState(OnScrollStateChangedListener.ScrollState.SCROLL_STATE_IDLE);
    }

    private void reset() {
        this.initView();
        this.removeAllViewsInLayout();
        this.requestLayout();
    }

    public void setSelection(int position) {
        this.mCurrentlySelectedAdapterIndex = position;
    }

    public View getSelectedView() {
        return this.getChild(this.mCurrentlySelectedAdapterIndex);
    }

    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mAdapterDataObserver);
        }
        if (adapter != null) {
            this.mHasNotifiedRunningLowOnData = false;
            this.mAdapter = adapter;
            this.mAdapter.registerDataSetObserver(this.mAdapterDataObserver);
        }
        this.initializeRecycledViewCache(this.mAdapter.getViewTypeCount());
        this.reset();
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    private void initializeRecycledViewCache(int viewTypeCount) {
        this.mRemovedViewsCache.clear();
        for (int i = 0; i < viewTypeCount; ++i) {
            this.mRemovedViewsCache.add(new LinkedList());
        }
    }

    private View getRecycledView(int adapterIndex) {
        int itemViewType = this.mAdapter.getItemViewType(adapterIndex);
        if (this.isItemViewTypeValid(itemViewType)) {
            return this.mRemovedViewsCache.get(itemViewType).poll();
        }
        return null;
    }

    private void recycleView(int adapterIndex, View view) {
        int itemViewType = this.mAdapter.getItemViewType(adapterIndex);
        if (this.isItemViewTypeValid(itemViewType)) {
            this.mRemovedViewsCache.get(itemViewType).offer(view);
        }
    }

    private boolean isItemViewTypeValid(int itemViewType) {
        return itemViewType < this.mRemovedViewsCache.size();
    }

    private void addAndMeasureChild(View child, int viewPos) {
        ViewGroup.LayoutParams params = this.getLayoutParams(child);
        this.addViewInLayout(child, viewPos, params, true);
        this.measureChild(child);
    }

    private void measureChild(View child) {
        ViewGroup.LayoutParams childLayoutParams = this.getLayoutParams(child);
        int childHeightSpec = ViewGroup.getChildMeasureSpec((int)this.mHeightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)childLayoutParams.height);
        int childWidthSpec = childLayoutParams.width > 0 ? View.MeasureSpec.makeMeasureSpec((int)childLayoutParams.width, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    private ViewGroup.LayoutParams getLayoutParams(View child) {
        ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new ViewGroup.LayoutParams(-2, -1);
        }
        return layoutParams;
    }

    @SuppressLint(value={"WrongCall"})
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mAdapter == null) {
            return;
        }
        this.invalidate();
        if (this.mDataChanged) {
            int oldCurrentX = this.mCurrentX;
            this.initView();
            this.removeAllViewsInLayout();
            this.mNextX = oldCurrentX;
            this.mDataChanged = false;
        }
        if (this.mRestoreX != null) {
            this.mNextX = this.mRestoreX;
            this.mRestoreX = null;
        }
        if (this.mFlingTracker.computeScrollOffset()) {
            this.mNextX = this.mFlingTracker.getCurrX();
        }
        if (this.mNextX < 0) {
            this.mNextX = 0;
            if (this.mEdgeGlowLeft.isFinished()) {
                this.mEdgeGlowLeft.onAbsorb((int)this.determineFlingAbsorbVelocity());
            }
            this.mFlingTracker.forceFinished(true);
            this.setCurrentScrollState(OnScrollStateChangedListener.ScrollState.SCROLL_STATE_IDLE);
        } else if (this.mNextX > this.mMaxX) {
            this.mNextX = this.mMaxX;
            if (this.mEdgeGlowRight.isFinished()) {
                this.mEdgeGlowRight.onAbsorb((int)this.determineFlingAbsorbVelocity());
            }
            this.mFlingTracker.forceFinished(true);
            this.setCurrentScrollState(OnScrollStateChangedListener.ScrollState.SCROLL_STATE_IDLE);
        }
        int dx = this.mCurrentX - this.mNextX;
        this.removeNonVisibleChildren(dx);
        this.fillList(dx);
        this.positionChildren(dx);
        this.mCurrentX = this.mNextX;
        if (this.determineMaxX()) {
            this.onLayout(changed, left, top, right, bottom);
            return;
        }
        if (this.mFlingTracker.isFinished()) {
            if (this.mCurrentScrollState == OnScrollStateChangedListener.ScrollState.SCROLL_STATE_FLING) {
                this.setCurrentScrollState(OnScrollStateChangedListener.ScrollState.SCROLL_STATE_IDLE);
            }
        } else {
            ViewCompat.postOnAnimation((View)this, (Runnable)this.mDelayedLayout);
        }
    }

    protected float getLeftFadingEdgeStrength() {
        int horizontalFadingEdgeLength = this.getHorizontalFadingEdgeLength();
        if (this.mCurrentX == 0) {
            return 0.0f;
        }
        if (this.mCurrentX < horizontalFadingEdgeLength) {
            return (float)this.mCurrentX / (float)horizontalFadingEdgeLength;
        }
        return 1.0f;
    }

    protected float getRightFadingEdgeStrength() {
        int horizontalFadingEdgeLength = this.getHorizontalFadingEdgeLength();
        if (this.mCurrentX == this.mMaxX) {
            return 0.0f;
        }
        if (this.mMaxX - this.mCurrentX < horizontalFadingEdgeLength) {
            return (float)(this.mMaxX - this.mCurrentX) / (float)horizontalFadingEdgeLength;
        }
        return 1.0f;
    }

    private float determineFlingAbsorbVelocity() {
        if (Build.VERSION.SDK_INT >= 14) {
            return IceCreamSandwichPlus.getCurrVelocity(this.mFlingTracker);
        }
        return 30.0f;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mHeightMeasureSpec = heightMeasureSpec;
    }

    private boolean determineMaxX() {
        View rightView;
        if (this.isLastItemInAdapter(this.mRightViewAdapterIndex) && (rightView = this.getRightmostChild()) != null) {
            int oldMaxX = this.mMaxX;
            this.mMaxX = this.mCurrentX + (rightView.getRight() - this.getPaddingLeft()) - this.getRenderWidth();
            if (this.mMaxX < 0) {
                this.mMaxX = 0;
            }
            if (this.mMaxX != oldMaxX) {
                return true;
            }
        }
        return false;
    }

    private void fillList(int dx) {
        int edge = 0;
        View child = this.getRightmostChild();
        if (child != null) {
            edge = child.getRight();
        }
        this.fillListRight(edge, dx);
        edge = 0;
        child = this.getLeftmostChild();
        if (child != null) {
            edge = child.getLeft();
        }
        this.fillListLeft(edge, dx);
    }

    private void removeNonVisibleChildren(int dx) {
        View child = this.getLeftmostChild();
        while (child != null && child.getRight() + dx <= 0) {
            this.mDisplayOffset += this.isLastItemInAdapter(this.mLeftViewAdapterIndex) ? child.getMeasuredWidth() : this.mDividerWidth + child.getMeasuredWidth();
            this.recycleView(this.mLeftViewAdapterIndex, child);
            this.removeViewInLayout(child);
            ++this.mLeftViewAdapterIndex;
            child = this.getLeftmostChild();
        }
        child = this.getRightmostChild();
        while (child != null && child.getLeft() + dx >= this.getWidth()) {
            this.recycleView(this.mRightViewAdapterIndex, child);
            this.removeViewInLayout(child);
            --this.mRightViewAdapterIndex;
            child = this.getRightmostChild();
        }
    }

    private void fillListRight(int rightEdge, int dx) {
        while (rightEdge + dx + this.mDividerWidth < this.getWidth() && this.mRightViewAdapterIndex + 1 < this.mAdapter.getCount()) {
            ++this.mRightViewAdapterIndex;
            if (this.mLeftViewAdapterIndex < 0) {
                this.mLeftViewAdapterIndex = this.mRightViewAdapterIndex;
            }
            View child = this.mAdapter.getView(this.mRightViewAdapterIndex, this.getRecycledView(this.mRightViewAdapterIndex), (ViewGroup)this);
            this.addAndMeasureChild(child, -1);
            rightEdge += (this.mRightViewAdapterIndex == 0 ? 0 : this.mDividerWidth) + child.getMeasuredWidth();
            this.determineIfLowOnData();
        }
    }

    private void fillListLeft(int leftEdge, int dx) {
        while (leftEdge + dx - this.mDividerWidth > 0 && this.mLeftViewAdapterIndex >= 1) {
            --this.mLeftViewAdapterIndex;
            View child = this.mAdapter.getView(this.mLeftViewAdapterIndex, this.getRecycledView(this.mLeftViewAdapterIndex), (ViewGroup)this);
            this.addAndMeasureChild(child, 0);
            this.mDisplayOffset -= (leftEdge -= this.mLeftViewAdapterIndex == 0 ? child.getMeasuredWidth() : this.mDividerWidth + child.getMeasuredWidth()) + dx == 0 ? child.getMeasuredWidth() : this.mDividerWidth + child.getMeasuredWidth();
        }
    }

    private void positionChildren(int dx) {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            this.mDisplayOffset += dx;
            int leftOffset = this.mDisplayOffset;
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                int left = leftOffset + this.getPaddingLeft();
                int top = this.getPaddingTop();
                int right = left + child.getMeasuredWidth();
                int bottom = top + child.getMeasuredHeight();
                child.layout(left, top, right, bottom);
                leftOffset += child.getMeasuredWidth() + this.mDividerWidth;
            }
        }
    }

    private View getLeftmostChild() {
        return this.getChildAt(0);
    }

    private View getRightmostChild() {
        return this.getChildAt(this.getChildCount() - 1);
    }

    private View getChild(int adapterIndex) {
        if (adapterIndex >= this.mLeftViewAdapterIndex && adapterIndex <= this.mRightViewAdapterIndex) {
            return this.getChildAt(adapterIndex - this.mLeftViewAdapterIndex);
        }
        return null;
    }

    private int getChildIndex(int x, int y) {
        int childCount = this.getChildCount();
        for (int index = 0; index < childCount; ++index) {
            this.getChildAt(index).getHitRect(this.mRect);
            if (!this.mRect.contains(x, y)) continue;
            return index;
        }
        return -1;
    }

    private boolean isLastItemInAdapter(int index) {
        return index == this.mAdapter.getCount() - 1;
    }

    private int getRenderHeight() {
        return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    private int getRenderWidth() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    public void scrollTo(int x) {
        this.mFlingTracker.startScroll(this.mNextX, 0, x - this.mNextX, 0);
        this.setCurrentScrollState(OnScrollStateChangedListener.ScrollState.SCROLL_STATE_FLING);
        this.requestLayout();
    }

    public int getFirstVisiblePosition() {
        return this.mLeftViewAdapterIndex;
    }

    public int getLastVisiblePosition() {
        return this.mRightViewAdapterIndex;
    }

    private void drawEdgeGlow(Canvas canvas) {
        if (this.mEdgeGlowLeft != null && !this.mEdgeGlowLeft.isFinished() && this.isEdgeGlowEnabled()) {
            int restoreCount = canvas.save();
            int height = this.getHeight();
            canvas.rotate(-90.0f, 0.0f, 0.0f);
            canvas.translate((float)(-height + this.getPaddingBottom()), 0.0f);
            this.mEdgeGlowLeft.setSize(this.getRenderHeight(), this.getRenderWidth());
            if (this.mEdgeGlowLeft.draw(canvas)) {
                this.invalidate();
            }
            canvas.restoreToCount(restoreCount);
        } else if (this.mEdgeGlowRight != null && !this.mEdgeGlowRight.isFinished() && this.isEdgeGlowEnabled()) {
            int restoreCount = canvas.save();
            int width = this.getWidth();
            canvas.rotate(90.0f, 0.0f, 0.0f);
            canvas.translate((float)this.getPaddingTop(), (float)(-width));
            this.mEdgeGlowRight.setSize(this.getRenderHeight(), this.getRenderWidth());
            if (this.mEdgeGlowRight.draw(canvas)) {
                this.invalidate();
            }
            canvas.restoreToCount(restoreCount);
        }
    }

    private void drawDividers(Canvas canvas) {
        int count = this.getChildCount();
        Rect bounds = this.mRect;
        this.mRect.top = this.getPaddingTop();
        this.mRect.bottom = this.mRect.top + this.getRenderHeight();
        for (int i = 0; i < count; ++i) {
            if (i == count - 1 && this.isLastItemInAdapter(this.mRightViewAdapterIndex)) continue;
            View child = this.getChildAt(i);
            bounds.left = child.getRight();
            bounds.right = child.getRight() + this.mDividerWidth;
            if (bounds.left < this.getPaddingLeft()) {
                bounds.left = this.getPaddingLeft();
            }
            if (bounds.right > this.getWidth() - this.getPaddingRight()) {
                bounds.right = this.getWidth() - this.getPaddingRight();
            }
            this.drawDivider(canvas, bounds);
            if (i != 0 || child.getLeft() <= this.getPaddingLeft()) continue;
            bounds.left = this.getPaddingLeft();
            bounds.right = child.getLeft();
            this.drawDivider(canvas, bounds);
        }
    }

    private void drawDivider(Canvas canvas, Rect bounds) {
        if (this.mDivider != null) {
            this.mDivider.setBounds(bounds);
            this.mDivider.draw(canvas);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawDividers(canvas);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawEdgeGlow(canvas);
    }

    protected void dispatchSetPressed(boolean pressed) {
    }

    protected boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        this.mFlingTracker.fling(this.mNextX, 0, (int)(-velocityX), 0, 0, this.mMaxX, 0, 0);
        this.setCurrentScrollState(OnScrollStateChangedListener.ScrollState.SCROLL_STATE_FLING);
        this.requestLayout();
        return true;
    }

    protected boolean onDown(MotionEvent e) {
        int index;
        this.mBlockTouchAction = !this.mFlingTracker.isFinished();
        this.mFlingTracker.forceFinished(true);
        this.setCurrentScrollState(OnScrollStateChangedListener.ScrollState.SCROLL_STATE_IDLE);
        this.unpressTouchedChild();
        if (!this.mBlockTouchAction && (index = this.getChildIndex((int)e.getX(), (int)e.getY())) >= 0) {
            this.mViewBeingTouched = this.getChildAt(index);
            if (this.mViewBeingTouched != null) {
                this.mViewBeingTouched.setPressed(true);
                this.refreshDrawableState();
            }
        }
        return true;
    }

    private void unpressTouchedChild() {
        if (this.mViewBeingTouched != null) {
            this.mViewBeingTouched.setPressed(false);
            this.refreshDrawableState();
            this.mViewBeingTouched = null;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1) {
            if (this.mFlingTracker == null || this.mFlingTracker.isFinished()) {
                this.setCurrentScrollState(OnScrollStateChangedListener.ScrollState.SCROLL_STATE_IDLE);
            }
            this.requestParentListViewToNotInterceptTouchEvents(false);
            this.releaseEdgeGlow();
        } else if (event.getAction() == 3) {
            this.unpressTouchedChild();
            this.releaseEdgeGlow();
            this.requestParentListViewToNotInterceptTouchEvents(false);
        }
        return super.onTouchEvent(event);
    }

    private void releaseEdgeGlow() {
        if (this.mEdgeGlowLeft != null) {
            this.mEdgeGlowLeft.onRelease();
        }
        if (this.mEdgeGlowRight != null) {
            this.mEdgeGlowRight.onRelease();
        }
    }

    public void setRunningOutOfDataListener(RunningOutOfDataListener listener, int numberOfItemsLeftConsideredLow) {
        this.mRunningOutOfDataListener = listener;
        this.mRunningOutOfDataThreshold = numberOfItemsLeftConsideredLow;
    }

    private void determineIfLowOnData() {
        if (this.mRunningOutOfDataListener != null && this.mAdapter != null && this.mAdapter.getCount() - (this.mRightViewAdapterIndex + 1) < this.mRunningOutOfDataThreshold && !this.mHasNotifiedRunningLowOnData) {
            this.mHasNotifiedRunningLowOnData = true;
            this.mRunningOutOfDataListener.onRunningOutOfData();
        }
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public void setOnScrollStateChangedListener(OnScrollStateChangedListener listener) {
        this.mOnScrollStateChangedListener = listener;
    }

    private void setCurrentScrollState(OnScrollStateChangedListener.ScrollState newScrollState) {
        if (this.mCurrentScrollState != newScrollState && this.mOnScrollStateChangedListener != null) {
            this.mOnScrollStateChangedListener.onScrollStateChanged(newScrollState);
        }
        this.mCurrentScrollState = newScrollState;
    }

    private void updateOverscrollAnimation(int scrolledOffset) {
        if (this.mEdgeGlowLeft == null || this.mEdgeGlowRight == null) {
            return;
        }
        int nextScrollPosition = this.mCurrentX + scrolledOffset;
        if (this.mFlingTracker == null || this.mFlingTracker.isFinished()) {
            if (nextScrollPosition < 0) {
                int overscroll = Math.abs(scrolledOffset);
                this.mEdgeGlowLeft.onPull((float)overscroll / (float)this.getRenderWidth());
                if (!this.mEdgeGlowRight.isFinished()) {
                    this.mEdgeGlowRight.onRelease();
                }
            } else if (nextScrollPosition > this.mMaxX) {
                int overscroll = Math.abs(scrolledOffset);
                this.mEdgeGlowRight.onPull((float)overscroll / (float)this.getRenderWidth());
                if (!this.mEdgeGlowLeft.isFinished()) {
                    this.mEdgeGlowLeft.onRelease();
                }
            }
        }
    }

    private boolean isEdgeGlowEnabled() {
        if (this.mAdapter == null || this.mAdapter.isEmpty()) {
            return false;
        }
        return this.mMaxX > 0;
    }

    @TargetApi(value=14)
    private static final class IceCreamSandwichPlus {
        private IceCreamSandwichPlus() {
        }

        public static float getCurrVelocity(Scroller scroller) {
            return scroller.getCurrVelocity();
        }

        static {
            if (Build.VERSION.SDK_INT < 14) {
                throw new RuntimeException("Should not get to IceCreamSandwichPlus class unless sdk is >= 14!");
            }
        }
    }

    @TargetApi(value=11)
    private static final class HoneycombPlus {
        private HoneycombPlus() {
        }

        public static void setFriction(Scroller scroller, float friction) {
            if (scroller != null) {
                scroller.setFriction(friction);
            }
        }

        static {
            if (Build.VERSION.SDK_INT < 11) {
                throw new RuntimeException("Should not get to HoneycombPlus class unless sdk is >= 11!");
            }
        }
    }

    public static interface OnScrollStateChangedListener {
        public void onScrollStateChanged(ScrollState var1);

        public static enum ScrollState {
            SCROLL_STATE_IDLE,
            SCROLL_STATE_TOUCH_SCROLL,
            SCROLL_STATE_FLING;

        }
    }

    public static interface RunningOutOfDataListener {
        public void onRunningOutOfData();
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return HorizontalListView.this.onDown(e);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return HorizontalListView.this.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            HorizontalListView.this.requestParentListViewToNotInterceptTouchEvents(true);
            HorizontalListView.this.setCurrentScrollState(OnScrollStateChangedListener.ScrollState.SCROLL_STATE_TOUCH_SCROLL);
            HorizontalListView.this.unpressTouchedChild();
            HorizontalListView.this.mNextX += (int)distanceX;
            HorizontalListView.this.updateOverscrollAnimation(Math.round(distanceX));
            HorizontalListView.this.requestLayout();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            HorizontalListView.this.unpressTouchedChild();
            AdapterView.OnItemClickListener onItemClickListener = HorizontalListView.this.getOnItemClickListener();
            int index = HorizontalListView.this.getChildIndex((int)e.getX(), (int)e.getY());
            if (index >= 0 && !HorizontalListView.this.mBlockTouchAction) {
                View child = HorizontalListView.this.getChildAt(index);
                int adapterIndex = HorizontalListView.this.mLeftViewAdapterIndex + index;
                if (onItemClickListener != null) {
                    onItemClickListener.onItemClick((AdapterView)HorizontalListView.this, child, adapterIndex, HorizontalListView.this.mAdapter.getItemId(adapterIndex));
                    return true;
                }
            }
            if (HorizontalListView.this.mOnClickListener != null && !HorizontalListView.this.mBlockTouchAction) {
                HorizontalListView.this.mOnClickListener.onClick((View)HorizontalListView.this);
            }
            return false;
        }

        public void onLongPress(MotionEvent e) {
            HorizontalListView.this.unpressTouchedChild();
            int index = HorizontalListView.this.getChildIndex((int)e.getX(), (int)e.getY());
            if (index >= 0 && !HorizontalListView.this.mBlockTouchAction) {
                int adapterIndex;
                boolean handled;
                View child = HorizontalListView.this.getChildAt(index);
                AdapterView.OnItemLongClickListener onItemLongClickListener = HorizontalListView.this.getOnItemLongClickListener();
                if (onItemLongClickListener != null && (handled = onItemLongClickListener.onItemLongClick((AdapterView)HorizontalListView.this, child, adapterIndex = HorizontalListView.this.mLeftViewAdapterIndex + index, HorizontalListView.this.mAdapter.getItemId(adapterIndex)))) {
                    HorizontalListView.this.performHapticFeedback(0);
                }
            }
        }
    }
}

