/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.widget.zoomview;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import me.nereo.multi_image_selector.widget.zoomview.GestureDetector;
import me.nereo.multi_image_selector.widget.zoomview.OnGestureListener;

public class CupcakeGestureDetector
implements GestureDetector {
    protected OnGestureListener mListener;
    private static final String LOG_TAG = "CupcakeGestureDetector";
    float mLastTouchX;
    float mLastTouchY;
    final float mTouchSlop;
    final float mMinimumVelocity;
    private VelocityTracker mVelocityTracker;
    private boolean mIsDragging;

    @Override
    public void setOnGestureListener(OnGestureListener listener) {
        this.mListener = listener;
    }

    public CupcakeGestureDetector(Context context) {
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mTouchSlop = configuration.getScaledTouchSlop();
    }

    float getActiveX(MotionEvent ev) {
        return ev.getX();
    }

    float getActiveY(MotionEvent ev) {
        return ev.getY();
    }

    @Override
    public boolean isScaling() {
        return false;
    }

    @Override
    public boolean isDragging() {
        return this.mIsDragging;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mVelocityTracker = VelocityTracker.obtain();
                if (null != this.mVelocityTracker) {
                    this.mVelocityTracker.addMovement(ev);
                }
                this.mLastTouchX = this.getActiveX(ev);
                this.mLastTouchY = this.getActiveY(ev);
                this.mIsDragging = false;
                break;
            }
            case 2: {
                float x = this.getActiveX(ev);
                float y = this.getActiveY(ev);
                float dx = x - this.mLastTouchX;
                float dy = y - this.mLastTouchY;
                if (!this.mIsDragging) {
                    boolean bl = this.mIsDragging = Math.sqrt(dx * dx + dy * dy) >= (double)this.mTouchSlop;
                }
                if (!this.mIsDragging) break;
                this.mListener.onDrag(dx, dy);
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                if (null == this.mVelocityTracker) break;
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 3: {
                if (null == this.mVelocityTracker) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 1: {
                if (this.mIsDragging && null != this.mVelocityTracker) {
                    this.mLastTouchX = this.getActiveX(ev);
                    this.mLastTouchY = this.getActiveY(ev);
                    this.mVelocityTracker.addMovement(ev);
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float vX = this.mVelocityTracker.getXVelocity();
                    float vY = this.mVelocityTracker.getYVelocity();
                    if (Math.max(Math.abs(vX), Math.abs(vY)) >= this.mMinimumVelocity) {
                        this.mListener.onFling(this.mLastTouchX, this.mLastTouchY, -vX, -vY);
                    }
                }
                if (null == this.mVelocityTracker) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }
}

