/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.widget.zoomview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import java.lang.ref.WeakReference;
import me.nereo.multi_image_selector.widget.zoomview.Compat;
import me.nereo.multi_image_selector.widget.zoomview.DefaultOnDoubleTapListener;
import me.nereo.multi_image_selector.widget.zoomview.GestureDetector;
import me.nereo.multi_image_selector.widget.zoomview.IPhotoView;
import me.nereo.multi_image_selector.widget.zoomview.OnGestureListener;
import me.nereo.multi_image_selector.widget.zoomview.ScrollerProxy;
import me.nereo.multi_image_selector.widget.zoomview.VersionedGestureDetector;

public class PhotoViewAttacher
implements IPhotoView,
View.OnTouchListener,
OnGestureListener,
ViewTreeObserver.OnGlobalLayoutListener {
    static final Interpolator sInterpolator = new AccelerateDecelerateInterpolator();
    int ZOOM_DURATION = 200;
    static final int EDGE_NONE = -1;
    static final int EDGE_LEFT = 0;
    static final int EDGE_RIGHT = 1;
    static final int EDGE_BOTH = 2;
    private float mMinScale = 1.0f;
    private float mMidScale = 1.75f;
    private float mMaxScale = 3.0f;
    private boolean mAllowParentInterceptOnEdge = true;
    private boolean mBlockParentIntercept = false;
    private WeakReference<ImageView> mImageView;
    private android.view.GestureDetector mGestureDetector;
    private GestureDetector mScaleDragDetector;
    private final Matrix mBaseMatrix = new Matrix();
    private final Matrix mDrawMatrix = new Matrix();
    private final Matrix mSuppMatrix = new Matrix();
    private final RectF mDisplayRect = new RectF();
    private final float[] mMatrixValues = new float[9];
    private OnMatrixChangedListener mMatrixChangeListener;
    private OnPhotoTapListener mPhotoTapListener;
    private OnViewTapListener mViewTapListener;
    private View.OnLongClickListener mLongClickListener;
    private OnScaleChangeListener mScaleChangeListener;
    private int mIvTop;
    private int mIvRight;
    private int mIvBottom;
    private int mIvLeft;
    private FlingRunnable mCurrentFlingRunnable;
    private int mScrollEdge = 2;
    private boolean mZoomEnabled;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;

    private static void checkZoomLevels(float minZoom, float midZoom, float maxZoom) {
        if (minZoom >= midZoom) {
            throw new IllegalArgumentException("MinZoom has to be less than MidZoom");
        }
        if (midZoom >= maxZoom) {
            throw new IllegalArgumentException("MidZoom has to be less than MaxZoom");
        }
    }

    private static boolean hasDrawable(ImageView imageView) {
        return null != imageView && null != imageView.getDrawable();
    }

    private static boolean isSupportedScaleType(ImageView.ScaleType scaleType) {
        if (null == scaleType) {
            return false;
        }
        switch (scaleType) {
            case MATRIX: {
                throw new IllegalArgumentException(scaleType.name() + " is not supported in PhotoView");
            }
        }
        return true;
    }

    private static void setImageViewScaleTypeMatrix(ImageView imageView) {
        if (null != imageView && !(imageView instanceof IPhotoView) && !ImageView.ScaleType.MATRIX.equals((Object)imageView.getScaleType())) {
            imageView.setScaleType(ImageView.ScaleType.MATRIX);
        }
    }

    public PhotoViewAttacher(ImageView imageView) {
        this(imageView, true);
    }

    public PhotoViewAttacher(ImageView imageView, boolean zoomable) {
        this.mImageView = new WeakReference<ImageView>(imageView);
        imageView.setDrawingCacheEnabled(true);
        imageView.setOnTouchListener((View.OnTouchListener)this);
        ViewTreeObserver observer = imageView.getViewTreeObserver();
        if (null != observer) {
            observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        PhotoViewAttacher.setImageViewScaleTypeMatrix(imageView);
        if (imageView.isInEditMode()) {
            return;
        }
        this.mScaleDragDetector = VersionedGestureDetector.newInstance(imageView.getContext(), this);
        this.mGestureDetector = new android.view.GestureDetector(imageView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent e) {
                if (null != PhotoViewAttacher.this.mLongClickListener) {
                    PhotoViewAttacher.this.mLongClickListener.onLongClick((View)PhotoViewAttacher.this.getImageView());
                }
            }
        });
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new DefaultOnDoubleTapListener(this));
        this.setZoomable(zoomable);
    }

    @Override
    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener newOnDoubleTapListener) {
        if (newOnDoubleTapListener != null) {
            this.mGestureDetector.setOnDoubleTapListener(newOnDoubleTapListener);
        } else {
            this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new DefaultOnDoubleTapListener(this));
        }
    }

    @Override
    public void setOnScaleChangeListener(OnScaleChangeListener onScaleChangeListener) {
        this.mScaleChangeListener = onScaleChangeListener;
    }

    @Override
    public boolean canZoom() {
        return this.mZoomEnabled;
    }

    public void cleanup() {
        if (null == this.mImageView) {
            return;
        }
        ImageView imageView = (ImageView)this.mImageView.get();
        if (null != imageView) {
            ViewTreeObserver observer = imageView.getViewTreeObserver();
            if (null != observer && observer.isAlive()) {
                observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            imageView.setOnTouchListener(null);
            this.cancelFling();
        }
        if (null != this.mGestureDetector) {
            this.mGestureDetector.setOnDoubleTapListener(null);
        }
        this.mMatrixChangeListener = null;
        this.mPhotoTapListener = null;
        this.mViewTapListener = null;
        this.mImageView = null;
    }

    @Override
    public RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDrawMatrix());
    }

    @Override
    public boolean setDisplayMatrix(Matrix finalMatrix) {
        if (finalMatrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        ImageView imageView = this.getImageView();
        if (null == imageView) {
            return false;
        }
        if (null == imageView.getDrawable()) {
            return false;
        }
        this.mSuppMatrix.set(finalMatrix);
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
        return true;
    }

    @Override
    public void setPhotoViewRotation(float degrees) {
        this.mSuppMatrix.setRotate(degrees % 360.0f);
        this.checkAndDisplayMatrix();
    }

    @Override
    public void setRotationTo(float degrees) {
        this.mSuppMatrix.setRotate(degrees % 360.0f);
        this.checkAndDisplayMatrix();
    }

    @Override
    public void setRotationBy(float degrees) {
        this.mSuppMatrix.postRotate(degrees % 360.0f);
        this.checkAndDisplayMatrix();
    }

    public ImageView getImageView() {
        ImageView imageView = null;
        if (null != this.mImageView) {
            imageView = (ImageView)this.mImageView.get();
        }
        if (null == imageView) {
            this.cleanup();
        }
        return imageView;
    }

    @Override
    @Deprecated
    public float getMinScale() {
        return this.getMinimumScale();
    }

    @Override
    public float getMinimumScale() {
        return this.mMinScale;
    }

    @Override
    @Deprecated
    public float getMidScale() {
        return this.getMediumScale();
    }

    @Override
    public float getMediumScale() {
        return this.mMidScale;
    }

    @Override
    @Deprecated
    public float getMaxScale() {
        return this.getMaximumScale();
    }

    @Override
    public float getMaximumScale() {
        return this.mMaxScale;
    }

    @Override
    public float getScale() {
        return (float)Math.sqrt((float)Math.pow(this.getValue(this.mSuppMatrix, 0), 2.0) + (float)Math.pow(this.getValue(this.mSuppMatrix, 3), 2.0));
    }

    @Override
    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    @Override
    public void onDrag(float dx, float dy) {
        if (this.mScaleDragDetector.isScaling()) {
            return;
        }
        ImageView imageView = this.getImageView();
        this.mSuppMatrix.postTranslate(dx, dy);
        this.checkAndDisplayMatrix();
        ViewParent parent = imageView.getParent();
        if (this.mAllowParentInterceptOnEdge && !this.mScaleDragDetector.isScaling() && !this.mBlockParentIntercept) {
            if ((this.mScrollEdge == 2 || this.mScrollEdge == 0 && dx >= 1.0f || this.mScrollEdge == 1 && dx <= -1.0f) && null != parent) {
                parent.requestDisallowInterceptTouchEvent(false);
            }
        } else if (null != parent) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    @Override
    public void onFling(float startX, float startY, float velocityX, float velocityY) {
        ImageView imageView = this.getImageView();
        this.mCurrentFlingRunnable = new FlingRunnable(imageView.getContext());
        this.mCurrentFlingRunnable.fling(this.getImageViewWidth(imageView), this.getImageViewHeight(imageView), (int)velocityX, (int)velocityY);
        imageView.post((Runnable)this.mCurrentFlingRunnable);
    }

    public void onGlobalLayout() {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            if (this.mZoomEnabled) {
                int top = imageView.getTop();
                int right = imageView.getRight();
                int bottom = imageView.getBottom();
                int left = imageView.getLeft();
                if (top != this.mIvTop || bottom != this.mIvBottom || left != this.mIvLeft || right != this.mIvRight) {
                    this.updateBaseMatrix(imageView.getDrawable());
                    this.mIvTop = top;
                    this.mIvRight = right;
                    this.mIvBottom = bottom;
                    this.mIvLeft = left;
                }
            } else {
                this.updateBaseMatrix(imageView.getDrawable());
            }
        }
    }

    @Override
    public void onScale(float scaleFactor, float focusX, float focusY) {
        if (this.getScale() < this.mMaxScale || scaleFactor < 1.0f) {
            if (null != this.mScaleChangeListener) {
                this.mScaleChangeListener.onScaleChange(scaleFactor, focusX, focusY);
            }
            this.mSuppMatrix.postScale(scaleFactor, scaleFactor, focusX, focusY);
            this.checkAndDisplayMatrix();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent ev) {
        boolean handled = false;
        if (this.mZoomEnabled && PhotoViewAttacher.hasDrawable((ImageView)v)) {
            ViewParent parent = v.getParent();
            switch (ev.getAction()) {
                case 0: {
                    if (null != parent) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.cancelFling();
                    break;
                }
                case 1: 
                case 3: {
                    RectF rect;
                    if (!(this.getScale() < this.mMinScale) || null == (rect = this.getDisplayRect())) break;
                    v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMinScale, rect.centerX(), rect.centerY()));
                    handled = true;
                }
            }
            if (null != this.mScaleDragDetector) {
                boolean wasScaling = this.mScaleDragDetector.isScaling();
                boolean wasDragging = this.mScaleDragDetector.isDragging();
                handled = this.mScaleDragDetector.onTouchEvent(ev);
                boolean didntScale = !wasScaling && !this.mScaleDragDetector.isScaling();
                boolean didntDrag = !wasDragging && !this.mScaleDragDetector.isDragging();
                boolean bl = this.mBlockParentIntercept = didntScale && didntDrag;
            }
            if (null != this.mGestureDetector && this.mGestureDetector.onTouchEvent(ev)) {
                handled = true;
            }
        }
        return handled;
    }

    @Override
    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.mAllowParentInterceptOnEdge = allow;
    }

    @Override
    @Deprecated
    public void setMinScale(float minScale) {
        this.setMinimumScale(minScale);
    }

    @Override
    public void setMinimumScale(float minimumScale) {
        PhotoViewAttacher.checkZoomLevels(minimumScale, this.mMidScale, this.mMaxScale);
        this.mMinScale = minimumScale;
    }

    @Override
    @Deprecated
    public void setMidScale(float midScale) {
        this.setMediumScale(midScale);
    }

    @Override
    public void setMediumScale(float mediumScale) {
        PhotoViewAttacher.checkZoomLevels(this.mMinScale, mediumScale, this.mMaxScale);
        this.mMidScale = mediumScale;
    }

    @Override
    @Deprecated
    public void setMaxScale(float maxScale) {
        this.setMaximumScale(maxScale);
    }

    @Override
    public void setMaximumScale(float maximumScale) {
        PhotoViewAttacher.checkZoomLevels(this.mMinScale, this.mMidScale, maximumScale);
        this.mMaxScale = maximumScale;
    }

    @Override
    public void setScaleLevels(float minimumScale, float mediumScale, float maximumScale) {
        PhotoViewAttacher.checkZoomLevels(minimumScale, mediumScale, maximumScale);
        this.mMinScale = minimumScale;
        this.mMidScale = mediumScale;
        this.mMaxScale = maximumScale;
    }

    @Override
    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.mLongClickListener = listener;
    }

    @Override
    public void setOnMatrixChangeListener(OnMatrixChangedListener listener) {
        this.mMatrixChangeListener = listener;
    }

    @Override
    public void setOnPhotoTapListener(OnPhotoTapListener listener) {
        this.mPhotoTapListener = listener;
    }

    @Override
    public OnPhotoTapListener getOnPhotoTapListener() {
        return this.mPhotoTapListener;
    }

    @Override
    public void setOnViewTapListener(OnViewTapListener listener) {
        this.mViewTapListener = listener;
    }

    @Override
    public OnViewTapListener getOnViewTapListener() {
        return this.mViewTapListener;
    }

    @Override
    public void setScale(float scale) {
        this.setScale(scale, false);
    }

    @Override
    public void setScale(float scale, boolean animate) {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            this.setScale(scale, imageView.getRight() / 2, imageView.getBottom() / 2, animate);
        }
    }

    @Override
    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            if (scale < this.mMinScale || scale > this.mMaxScale) {
                return;
            }
            if (animate) {
                imageView.post((Runnable)new AnimatedZoomRunnable(this.getScale(), scale, focalX, focalY));
            } else {
                this.mSuppMatrix.setScale(scale, scale, focalX, focalY);
                this.checkAndDisplayMatrix();
            }
        }
    }

    @Override
    public void setScaleType(ImageView.ScaleType scaleType) {
        if (PhotoViewAttacher.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    @Override
    public void setZoomable(boolean zoomable) {
        this.mZoomEnabled = zoomable;
        this.update();
    }

    public void update() {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            if (this.mZoomEnabled) {
                PhotoViewAttacher.setImageViewScaleTypeMatrix(imageView);
                this.updateBaseMatrix(imageView.getDrawable());
            } else {
                this.resetMatrix();
            }
        }
    }

    @Override
    public Matrix getDisplayMatrix() {
        return new Matrix(this.getDrawMatrix());
    }

    public Matrix getDrawMatrix() {
        this.mDrawMatrix.set(this.mBaseMatrix);
        this.mDrawMatrix.postConcat(this.mSuppMatrix);
        return this.mDrawMatrix;
    }

    private void cancelFling() {
        if (null != this.mCurrentFlingRunnable) {
            this.mCurrentFlingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    private void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            this.setImageViewMatrix(this.getDrawMatrix());
        }
    }

    private void checkImageViewScaleType() {
        ImageView imageView = this.getImageView();
        if (null != imageView && !(imageView instanceof IPhotoView) && !ImageView.ScaleType.MATRIX.equals((Object)imageView.getScaleType())) {
            throw new IllegalStateException("The ImageView's ScaleType has been changed since attaching a PhotoViewAttacher");
        }
    }

    private boolean checkMatrixBounds() {
        ImageView imageView = this.getImageView();
        if (null == imageView) {
            return false;
        }
        RectF rect = this.getDisplayRect(this.getDrawMatrix());
        if (null == rect) {
            return false;
        }
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int viewHeight = this.getImageViewHeight(imageView);
        if (height <= (float)viewHeight) {
            switch (this.mScaleType) {
                case FIT_START: {
                    deltaY = -rect.top;
                    break;
                }
                case FIT_END: {
                    deltaY = (float)viewHeight - height - rect.top;
                    break;
                }
                default: {
                    deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
                    break;
                }
            }
        } else if (rect.top > 0.0f) {
            deltaY = -rect.top;
        } else if (rect.bottom < (float)viewHeight) {
            deltaY = (float)viewHeight - rect.bottom;
        }
        int viewWidth = this.getImageViewWidth(imageView);
        if (width <= (float)viewWidth) {
            switch (this.mScaleType) {
                case FIT_START: {
                    deltaX = -rect.left;
                    break;
                }
                case FIT_END: {
                    deltaX = (float)viewWidth - width - rect.left;
                    break;
                }
                default: {
                    deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
                }
            }
            this.mScrollEdge = 2;
        } else if (rect.left > 0.0f) {
            this.mScrollEdge = 0;
            deltaX = -rect.left;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
            this.mScrollEdge = 1;
        } else {
            this.mScrollEdge = -1;
        }
        this.mSuppMatrix.postTranslate(deltaX, deltaY);
        return true;
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable d;
        ImageView imageView = this.getImageView();
        if (null != imageView && null != (d = imageView.getDrawable())) {
            this.mDisplayRect.set(0.0f, 0.0f, (float)d.getIntrinsicWidth(), (float)d.getIntrinsicHeight());
            matrix.mapRect(this.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    @Override
    public Bitmap getVisibleRectangleBitmap() {
        ImageView imageView = this.getImageView();
        return imageView == null ? null : imageView.getDrawingCache();
    }

    @Override
    public void setZoomTransitionDuration(int milliseconds) {
        if (milliseconds < 0) {
            milliseconds = 200;
        }
        this.ZOOM_DURATION = milliseconds;
    }

    @Override
    public IPhotoView getIPhotoViewImplementation() {
        return this;
    }

    private float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    private void resetMatrix() {
        this.mSuppMatrix.reset();
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            RectF displayRect;
            this.checkImageViewScaleType();
            imageView.setImageMatrix(matrix);
            if (null != this.mMatrixChangeListener && null != (displayRect = this.getDisplayRect(matrix))) {
                this.mMatrixChangeListener.onMatrixChanged(displayRect);
            }
        }
    }

    private void updateBaseMatrix(Drawable d) {
        ImageView imageView = this.getImageView();
        if (null == imageView || null == d) {
            return;
        }
        float viewWidth = this.getImageViewWidth(imageView);
        float viewHeight = this.getImageViewHeight(imageView);
        int drawableWidth = d.getIntrinsicWidth();
        int drawableHeight = d.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float widthScale = viewWidth / (float)drawableWidth;
        float heightScale = viewHeight / (float)drawableHeight;
        if (this.mScaleType == ImageView.ScaleType.CENTER) {
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth) / 2.0f, (viewHeight - (float)drawableHeight) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_CROP) {
            float scale = Math.max(widthScale, heightScale);
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_INSIDE) {
            float scale = Math.min(1.0f, Math.min(widthScale, heightScale));
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else {
            RectF mTempSrc = new RectF(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
            RectF mTempDst = new RectF(0.0f, 0.0f, viewWidth, viewHeight);
            switch (this.mScaleType) {
                case FIT_CENTER: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case FIT_START: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.START);
                    break;
                }
                case FIT_END: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.END);
                    break;
                }
                case FIT_XY: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.FILL);
                    break;
                }
            }
        }
        this.resetMatrix();
    }

    private int getImageViewWidth(ImageView imageView) {
        if (null == imageView) {
            return 0;
        }
        return imageView.getWidth() - imageView.getPaddingLeft() - imageView.getPaddingRight();
    }

    private int getImageViewHeight(ImageView imageView) {
        if (null == imageView) {
            return 0;
        }
        return imageView.getHeight() - imageView.getPaddingTop() - imageView.getPaddingBottom();
    }

    private class FlingRunnable
    implements Runnable {
        private final ScrollerProxy mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            this.mScroller = ScrollerProxy.getScroller(context);
        }

        public void cancelFling() {
            this.mScroller.forceFinished(true);
        }

        public void fling(int viewWidth, int viewHeight, int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            RectF rect = PhotoViewAttacher.this.getDisplayRect();
            if (null == rect) {
                return;
            }
            int startX = Math.round(-rect.left);
            if ((float)viewWidth < rect.width()) {
                minX = 0;
                maxX = Math.round(rect.width() - (float)viewWidth);
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(-rect.top);
            if ((float)viewHeight < rect.height()) {
                minY = 0;
                maxY = Math.round(rect.height() - (float)viewHeight);
            } else {
                minY = maxY = startY;
            }
            this.mCurrentX = startX;
            this.mCurrentY = startY;
            if (startX != maxX || startY != maxY) {
                this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
            }
        }

        @Override
        public void run() {
            if (this.mScroller.isFinished()) {
                return;
            }
            ImageView imageView = PhotoViewAttacher.this.getImageView();
            if (null != imageView && this.mScroller.computeScrollOffset()) {
                int newX = this.mScroller.getCurrX();
                int newY = this.mScroller.getCurrY();
                PhotoViewAttacher.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - newX), (float)(this.mCurrentY - newY));
                PhotoViewAttacher.this.setImageViewMatrix(PhotoViewAttacher.this.getDrawMatrix());
                this.mCurrentX = newX;
                this.mCurrentY = newY;
                Compat.postOnAnimation((View)imageView, this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        private final float mFocalX;
        private final float mFocalY;
        private final long mStartTime;
        private final float mZoomStart;
        private final float mZoomEnd;

        public AnimatedZoomRunnable(float currentZoom, float targetZoom, float focalX, float focalY) {
            this.mFocalX = focalX;
            this.mFocalY = focalY;
            this.mStartTime = System.currentTimeMillis();
            this.mZoomStart = currentZoom;
            this.mZoomEnd = targetZoom;
        }

        @Override
        public void run() {
            ImageView imageView = PhotoViewAttacher.this.getImageView();
            if (imageView == null) {
                return;
            }
            float t = this.interpolate();
            float scale = this.mZoomStart + t * (this.mZoomEnd - this.mZoomStart);
            float deltaScale = scale / PhotoViewAttacher.this.getScale();
            PhotoViewAttacher.this.onScale(deltaScale, this.mFocalX, this.mFocalY);
            if (t < 1.0f) {
                Compat.postOnAnimation((View)imageView, this);
            }
        }

        private float interpolate() {
            float t = 1.0f * (float)(System.currentTimeMillis() - this.mStartTime) / (float)PhotoViewAttacher.this.ZOOM_DURATION;
            t = Math.min(1.0f, t);
            t = sInterpolator.getInterpolation(t);
            return t;
        }
    }

    public static interface OnViewTapListener {
        public void onViewTap(View var1, float var2, float var3);
    }

    public static interface OnPhotoTapListener {
        public void onPhotoTap(View var1, float var2, float var3);
    }

    public static interface OnScaleChangeListener {
        public void onScaleChange(float var1, float var2, float var3);
    }

    public static interface OnMatrixChangedListener {
        public void onMatrixChanged(RectF var1);
    }
}

