/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.ext.elasticsearch.springboot.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.mhuang.core.check.CheckAssert;
import tech.mhuang.ext.elasticsearch.admin.ESFramework;
import tech.mhuang.ext.elasticsearch.admin.bean.ESInfo;
import tech.mhuang.ext.elasticsearch.admin.external.IESExternal;
import tech.mhuang.ext.elasticsearch.springboot.configuration.ESProperties;
import tech.mhuang.ext.elasticsearch.springboot.configuration.SpringESExternal;
import tech.mhuang.ext.spring.start.SpringContextHolder;
import tech.mhuang.ext.springboot.context.SpringBootExtAutoConfiguration;

@Configuration
@ConditionalOnClass(value={ESFramework.class})
@EnableConfigurationProperties(value={ESProperties.class})
@ConditionalOnProperty(prefix="mhuang.elasticsearch", name={"enable"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={SpringBootExtAutoConfiguration.class})
public class ESAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ESAutoConfiguration.class);
    private final ESProperties properties;

    public ESAutoConfiguration(ESProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public IESExternal esExternal() {
        return new SpringESExternal();
    }

    @Bean
    @ConditionalOnMissingBean
    public ESFramework esFramework(IESExternal esExternal, SpringContextHolder springContextHolder) {
        CheckAssert.check((Object)((Object)this.properties), (Object)"es properties invalid...");
        CheckAssert.check((Object)springContextHolder, (Object)"SpringContextHolder\u4e0d\u5b58\u5728\u3001\u8bf7\u8bbe\u7f6emhuang.holder.enable=true");
        ESFramework framework = new ESFramework((ESInfo)this.properties);
        framework.external(esExternal);
        framework.start();
        return framework;
    }
}

