/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.elasticsearch.admin;

import tech.mhuang.pacebox.core.builder.BaseBuilder;
import tech.mhuang.pacebox.elasticsearch.admin.ESFramework;
import tech.mhuang.pacebox.elasticsearch.admin.bean.ESInfo;

public class ESBuilder {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements BaseBuilder<ESFramework> {
        private ESInfo info = new ESInfo();

        Builder() {
        }

        public ProducerBuilder createProducerBuilder() {
            return new ProducerBuilder();
        }

        public Builder bindProducer(String key, ESInfo.ESBean value) {
            this.info.getBeanMap().put(key, value);
            return this;
        }

        public ESFramework builder() {
            return new ESFramework(this.info);
        }
    }

    public static class ProducerBuilder
    implements BaseBuilder<ESInfo.ESBean> {
        private ESInfo.ESBean info = new ESInfo.ESBean();

        public ProducerBuilder enable(boolean enable) {
            this.info.setEnable(enable);
            return this;
        }

        public ProducerBuilder url(String url) {
            this.info.setUrl(url);
            return this;
        }

        public ProducerBuilder connectNum(Integer connectNum) {
            this.info.setConnectNum(connectNum);
            return this;
        }

        public ProducerBuilder connectPerRoute(Integer connectPerRoute) {
            this.info.setConnectPerRoute(connectPerRoute);
            return this;
        }

        public ProducerBuilder connectionRequestTimeout(Integer connectionRequestTimeout) {
            this.info.setConnectionRequestTimeout(connectionRequestTimeout);
            return this;
        }

        public ProducerBuilder socketTimeout(Integer socketTimeout) {
            this.info.setSocketTimeout(socketTimeout);
            return this;
        }

        public ProducerBuilder connectionTimeout(Integer connectionTimeout) {
            this.info.setConnectionTimeout(connectionTimeout);
            return this;
        }

        public ESInfo.ESBean builder() {
            return this.info;
        }
    }
}

