/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.elasticsearch.admin;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mhuang.pacebox.core.util.StringUtil;
import tech.mhuang.pacebox.elasticsearch.admin.bean.ESInfo;
import tech.mhuang.pacebox.elasticsearch.admin.external.IESExternal;
import tech.mhuang.pacebox.elasticsearch.admin.factory.IESFactory;

public class ESFramework {
    private static final Logger log = LoggerFactory.getLogger(ESFramework.class);
    private ESInfo info;
    private IESExternal external;
    private Map<String, IESFactory> factory = new ConcurrentHashMap<String, IESFactory>();

    public IESFactory getFactory(String key) {
        return this.factory.get(key);
    }

    public ESFramework(ESInfo info) {
        this.info = info;
    }

    public ESFramework external(IESExternal external) {
        this.external = external;
        return this;
    }

    public void start() {
        if (this.external == null) {
            this.external = new IESExternal(){};
        }
        log.info("\u6b63\u5728\u542f\u52a8elasticsearch...");
        log.info("\u6b63\u5728\u88c5\u8f7delasticsearch\u914d\u7f6e,{}", (Object)this.info);
        this.info.getBeanMap().forEach((key, bean) -> {
            if (bean.isEnable()) {
                RestHighLevelClient client = this.loadProperties((ESInfo.ESBean)bean);
                IESFactory esFactory = this.external.create((String)key);
                esFactory.setClient(client);
                esFactory.setName((String)key);
                this.factory.put((String)key, esFactory);
            }
        });
        log.info("elasticsearch \u914d\u7f6e\u88c5\u8f7d\u5b8c\u6210...");
        log.info("elasticsearch \u542f\u52a8\u6210\u529f");
    }

    private RestHighLevelClient loadProperties(ESInfo.ESBean bean) {
        String urls = bean.getUrl();
        List<HttpHost> hostList = Arrays.stream(StringUtil.split((CharSequence)urls, (CharSequence)",")).map(url -> HttpHost.create((String)url)).collect(Collectors.toList());
        RestClientBuilder builder = RestClient.builder((HttpHost[])hostList.toArray(new HttpHost[hostList.size()]));
        this.setterClientConfig(builder, bean);
        return new RestHighLevelClient(builder);
    }

    private void setterClientConfig(RestClientBuilder builder, ESInfo.ESBean bean) {
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder.setConnectTimeout(bean.getConnectionTimeout().intValue());
            requestConfigBuilder.setSocketTimeout(bean.getSocketTimeout().intValue());
            requestConfigBuilder.setConnectionRequestTimeout(bean.getConnectionRequestTimeout().intValue());
            return requestConfigBuilder;
        });
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.setMaxConnTotal(bean.getConnectNum().intValue());
            httpClientBuilder.setMaxConnPerRoute(bean.getConnectPerRoute().intValue());
            return httpClientBuilder;
        });
    }
}

