/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.elasticsearch.server.query;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Stack;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mhuang.pacebox.core.util.CollectionUtil;
import tech.mhuang.pacebox.elasticsearch.server.query.ESQueryAware;
import tech.mhuang.pacebox.elasticsearch.server.query.OperatorContext;
import tech.mhuang.pacebox.elasticsearch.server.query.OrderType;
import tech.mhuang.pacebox.elasticsearch.server.query.QueryContext;
import tech.mhuang.pacebox.elasticsearch.server.query.QueryQuota;

public abstract class AbstractESQueryAware
implements ESQueryAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractESQueryAware.class);

    protected void analizeNotScollContext(SearchRequest searchRequest, SearchSourceBuilder sourceBuilder, QueryContext queryContext) {
        BoolQueryBuilder boolQueryBuilder = this.analizeCommonContext(sourceBuilder, queryContext);
        if (queryContext.getFrom() != null) {
            log.debug("\u5f00\u59cb  {}", (Object)queryContext.getFrom());
            sourceBuilder.from(queryContext.getFrom().intValue());
        }
        if (queryContext.getIndexNames() != null && queryContext.getIndexNames().length > 0) {
            log.debug("\u8bbe\u7f6e\u641c\u7d22\u7684\u7d22\u5f15  {}", (Object[])queryContext.getIndexNames());
            searchRequest.indices(queryContext.getIndexNames());
        }
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
    }

    private BoolQueryBuilder analizeCommonContext(SearchSourceBuilder sourceBuilder, QueryContext queryContext) {
        BoolQueryBuilder boolQueryBuilder = this.analizeOnlyContexts(queryContext);
        if (queryContext.getSize() != null) {
            log.debug("\u9650\u5236\u6761\u6570 {}", (Object)queryContext.getSize());
            sourceBuilder.size(queryContext.getSize().intValue());
        }
        if (queryContext.getOrders() != null && queryContext.getOrders().size() > 0) {
            queryContext.getOrders().forEach(t -> sourceBuilder.sort(new FieldSortBuilder(t.getFieldName()).order(t.getOrderType() == OrderType.ASC ? SortOrder.ASC : SortOrder.DESC)));
        }
        return boolQueryBuilder;
    }

    protected void analizeScollContext(SearchScrollRequest searchRequest, QueryContext queryContext) {
        searchRequest.scroll(TimeValue.timeValueMinutes((long)(queryContext.getScrollTimeout() == null ? 30L : queryContext.getScrollTimeout())));
    }

    protected void analizeFirstScollContext(SearchRequest searchRequest, QueryContext queryContext) {
        searchRequest.scroll(TimeValue.timeValueMinutes((long)(queryContext.getScrollTimeout() == null ? 30L : queryContext.getScrollTimeout())));
    }

    protected BoolQueryBuilder analizeOnlyContexts(QueryContext queryContext) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ArrayList<OperatorContext> temps = new ArrayList<OperatorContext>(queryContext.getContexts());
        Stack<String> params = new Stack<String>();
        if (CollectionUtil.isEmpty(temps)) {
            log.debug("\u6ca1\u6709\u4efb\u4f55\u6761\u4ef6");
            MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
            boolQueryBuilder.must((QueryBuilder)queryBuilder);
        } else {
            if (temps.size() <= 1) {
                OperatorContext context = (OperatorContext)temps.get(0);
                if (context.getQueryQuota() == QueryQuota.CONDITION) {
                    params.push(this.getCalcMessage(context));
                    boolQueryBuilder.must(this.addCondition(context));
                } else {
                    log.debug("\u6ca1\u6709\u4efb\u4f55\u6761\u4ef6");
                    MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
                    boolQueryBuilder.must((QueryBuilder)queryBuilder);
                }
            } else {
                Optional<OperatorContext> brackets;
                Stack<OperatorContext> stacks = new Stack<OperatorContext>();
                ArrayList<OperatorContext> afterStacks = new ArrayList<OperatorContext>();
                for (OperatorContext t2 : temps) {
                    block0 : switch (t2.getQueryQuota()) {
                        case GT: {
                            while (!stacks.isEmpty()) {
                                OperatorContext temp = (OperatorContext)stacks.peek();
                                if (temp.getQueryQuota() == QueryQuota.LT) {
                                    stacks.pop();
                                    break block0;
                                }
                                temp = (OperatorContext)stacks.pop();
                                afterStacks.add(temp);
                            }
                            break;
                        }
                        case LT: 
                        case AND: 
                        case OR: {
                            stacks.push(t2);
                            break;
                        }
                        case CONDITION: {
                            afterStacks.add(t2);
                        }
                    }
                }
                if (!stacks.isEmpty()) {
                    while (!stacks.isEmpty()) {
                        afterStacks.add((OperatorContext)stacks.pop());
                    }
                }
                if ((brackets = afterStacks.parallelStream().filter(t -> t.getQueryQuota() == QueryQuota.GT || t.getQueryQuota() == QueryQuota.LT).findFirst()).isPresent()) {
                    throw new IllegalArgumentException("\u6761\u4ef6\u62ec\u53f7\u4e0d\u5339\u914d\uff01");
                }
                Stack<Object> fixStack = new Stack<Object>();
                for (OperatorContext t3 : afterStacks) {
                    if (t3.getQueryQuota() == QueryQuota.AND || t3.getQueryQuota() == QueryQuota.OR) {
                        if (fixStack.size() < 2) {
                            throw new IllegalArgumentException("and \u6216\u8005 or\u7684\u8fd0\u7b97\u53c2\u6570\u4e0d\u5339\u914d");
                        }
                        Object first = fixStack.pop();
                        OperatorContext second = (OperatorContext)fixStack.pop();
                        BoolQueryBuilder resultBuild = null;
                        QueryBuilder firstBuilder = null;
                        QueryBuilder secondBuilder = this.addCondition(second);
                        firstBuilder = OperatorContext.class.isInstance(first) ? this.addCondition((OperatorContext)first) : (QueryBuilder)first;
                        String calcMessageSecond = this.getCalcMessage(second);
                        String calcFistMessage = null;
                        if (OperatorContext.class.isInstance(first)) {
                            params.push(")");
                            params.push(calcMessageSecond);
                            params.push(t3.getQueryQuota().getMessage());
                            calcFistMessage = this.getCalcMessage((OperatorContext)first);
                        } else {
                            params.push(t3.getQueryQuota().getMessage());
                            params.push(")");
                            params.push(calcMessageSecond);
                        }
                        resultBuild = t3.getQueryQuota() == QueryQuota.AND ? QueryBuilders.boolQuery().must(firstBuilder).must(secondBuilder) : QueryBuilders.boolQuery().should(firstBuilder).should(secondBuilder);
                        if (calcFistMessage != null) {
                            params.push(calcFistMessage);
                        }
                        params.push("(");
                        fixStack.push(resultBuild);
                        continue;
                    }
                    fixStack.push(t3);
                }
                boolQueryBuilder = (BoolQueryBuilder)fixStack.pop();
            }
            this.printMessage(params);
        }
        return boolQueryBuilder;
    }

    protected void printMessage(Stack<String> params) {
        if (log.isDebugEnabled() && !params.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            while (!params.isEmpty()) {
                builder.append(" ").append(params.pop()).append(" ");
            }
            log.debug("\u641c\u7d22\u6761\u4ef6\uff1a" + builder.toString());
        }
    }

    protected QueryBuilder addCondition(OperatorContext context) {
        TermsQueryBuilder queryBuilder = null;
        switch (context.getOperateType()) {
            case EQUALS: {
                this.checkValue(1, context);
                queryBuilder = QueryBuilders.termsQuery((String)context.getFieldName(), (Object[])context.getValues());
                break;
            }
            case LIKE: {
                this.checkValue(1, context);
                queryBuilder = QueryBuilders.wildcardQuery((String)context.getFieldName(), (String)"*".concat(context.getValues()[0].toString()).concat("*"));
                break;
            }
            case GT: {
                this.checkValue(1, context);
                queryBuilder = QueryBuilders.rangeQuery((String)context.getFieldName()).from(context.getValues()[0], false);
                break;
            }
            case LT: {
                this.checkValue(1, context);
                queryBuilder = QueryBuilders.rangeQuery((String)context.getFieldName()).to(context.getValues()[0], false);
                break;
            }
            case NOTEQUALS: {
                this.checkValue(1, context);
                queryBuilder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)context.getFieldName(), (Object[])context.getValues()));
                break;
            }
            case GTE: {
                this.checkValue(1, context);
                queryBuilder = QueryBuilders.rangeQuery((String)context.getFieldName()).from(context.getValues()[0], true);
                break;
            }
            case LTE: {
                this.checkValue(1, context);
                queryBuilder = QueryBuilders.rangeQuery((String)context.getFieldName()).to(context.getValues()[0], true);
                break;
            }
            case BETWEENIN_CLUDE: {
                this.checkValue(2, context);
                queryBuilder = QueryBuilders.rangeQuery((String)context.getFieldName()).from(context.getValues()[0], true).to(context.getValues()[1], true);
                break;
            }
            case BETWEEN_INCLUDE_LEFT: {
                this.checkValue(2, context);
                queryBuilder = QueryBuilders.rangeQuery((String)context.getFieldName()).from(context.getValues()[0], true).to(context.getValues()[1], false);
                break;
            }
            case BETWEEN_INCLUDE_RIGHT: {
                this.checkValue(2, context);
                queryBuilder = QueryBuilders.rangeQuery((String)context.getFieldName()).from(context.getValues()[0], false).to(context.getValues()[1], true);
                break;
            }
            case BETWEEN_NOT_INCLUDE: {
                this.checkValue(2, context);
                queryBuilder = QueryBuilders.rangeQuery((String)context.getFieldName()).from(context.getValues()[0], false).to(context.getValues()[1], false);
                break;
            }
            case REGEX: {
                this.checkValue(1, context);
                queryBuilder = QueryBuilders.regexpQuery((String)context.getFieldName(), (String)context.getValues()[0].toString());
            }
        }
        return queryBuilder;
    }

    protected void checkValue(int length, OperatorContext context) {
        if (context.getValues().length < length) {
            throw new IllegalArgumentException(context.getFieldName().concat(" values argument length less than ").concat(length + ""));
        }
        for (Object value : context.getValues()) {
            if (value != null) continue;
            throw new IllegalArgumentException(context.getFieldName().concat(" exists argument value  is null "));
        }
    }

    protected String getCalcMessage(OperatorContext second) {
        MessageFormat format = new MessageFormat(second.getOperateType().getMessage());
        Object[] messages = new Object[second.getValues().length + 1];
        messages[0] = second.getFieldName();
        System.arraycopy(second.getValues(), 0, messages, 1, second.getValues().length);
        return format.format(messages);
    }
}

