/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.elasticsearch.server.query;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mhuang.pacebox.elasticsearch.model.query.ESPage;
import tech.mhuang.pacebox.elasticsearch.server.query.AbstractESQuery;
import tech.mhuang.pacebox.elasticsearch.server.query.AbstractESQueryAware;
import tech.mhuang.pacebox.elasticsearch.server.query.ESQueryAware;
import tech.mhuang.pacebox.elasticsearch.server.query.QueryContext;

public class DefaultESQuery
extends AbstractESQuery {
    private static final Logger log = LoggerFactory.getLogger(DefaultESQuery.class);

    public DefaultESQuery(RestHighLevelClient client) {
        super(client);
    }

    @Override
    public ESQueryAware query(QueryContext queryContext) {
        return new DefaultEsQueryResult(queryContext, this.client);
    }

    class DefaultEsQueryResult
    extends AbstractESQueryAware {
        private QueryContext queryContext = null;
        private RestHighLevelClient client = null;
        private SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        private SearchRequest searchRequest = new SearchRequest();
        private SearchScrollRequest searchScrollRequest = new SearchScrollRequest();

        DefaultEsQueryResult(QueryContext queryContext, RestHighLevelClient client) {
            this.queryContext = queryContext;
            this.client = client;
        }

        @Override
        public <T> List<T> list(Class<T> clz) {
            SearchResponse response = null;
            try {
                ArrayList<Object> results = new ArrayList<Object>();
                this.analizeNotScollContext(this.searchRequest, this.searchSourceBuilder, this.queryContext);
                if (this.queryContext.getSize() == null) {
                    this.searchSourceBuilder.size(10000);
                    log.warn("No size is set, the system defaults to  maximum 10000");
                }
                this.searchRequest.source(this.searchSourceBuilder);
                response = this.client.search(this.searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                if (hits != null && hits.getHits() != null && hits.getHits().length > 0) {
                    for (SearchHit searchHit : response.getHits()) {
                        Object obj = JSON.parseObject((String)searchHit.getSourceAsString(), clz);
                        results.add(obj);
                    }
                }
                ArrayList<Object> arrayList = results;
                return arrayList;
            }
            catch (Exception e) {
                throw new ElasticsearchException((Throwable)e);
            }
        }

        @Override
        public <T> ESPage<T> page(Class<T> clz) {
            ESPage esPage = new ESPage();
            SearchResponse response = null;
            try {
                String scrollId = null;
                SearchHits hits = null;
                if (this.queryContext.getScrollId() == null) {
                    this.analizeNotScollContext(this.searchRequest, this.searchSourceBuilder, this.queryContext);
                    this.searchRequest.source(this.searchSourceBuilder);
                    this.analizeFirstScollContext(this.searchRequest, this.queryContext);
                    response = this.client.search(this.searchRequest, RequestOptions.DEFAULT);
                    scrollId = response.getScrollId();
                    hits = response.getHits();
                } else {
                    this.analizeScollContext(this.searchScrollRequest, this.queryContext);
                    SearchScrollRequest scrollRequest = new SearchScrollRequest(this.queryContext.getScrollId());
                    SearchResponse searchScrollResponse = this.client.scroll(scrollRequest, RequestOptions.DEFAULT);
                    scrollId = searchScrollResponse.getScrollId();
                    hits = searchScrollResponse.getHits();
                }
                long totalHits = hits.getTotalHits().value;
                esPage.setTotal(totalHits);
                ArrayList<Object> results = new ArrayList<Object>();
                if (hits != null && hits.getHits() != null && hits.getHits().length > 0) {
                    for (SearchHit searchHit : hits) {
                        Object obj = JSON.parseObject((String)searchHit.getSourceAsString(), clz);
                        results.add(obj);
                    }
                }
                esPage.setScrollId(scrollId);
                esPage.setRows(results);
                ESPage eSPage = esPage;
                return eSPage;
            }
            catch (Exception e) {
                throw new ElasticsearchException((Throwable)e);
            }
        }

        @Override
        public <T> T single(Class<T> clz) {
            this.queryContext.size(1);
            List<T> results = this.list(clz);
            return results.size() == 0 ? null : (T)results.get(0);
        }
    }
}

