/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.elasticsearch.server.query;

import tech.mhuang.pacebox.elasticsearch.model.query.ESOrder;
import tech.mhuang.pacebox.elasticsearch.server.query.OperatorContext;
import tech.mhuang.pacebox.elasticsearch.server.query.OperatorType;
import tech.mhuang.pacebox.elasticsearch.server.query.OrderType;
import tech.mhuang.pacebox.elasticsearch.server.query.QueryContext;
import tech.mhuang.pacebox.elasticsearch.server.query.QueryQuota;

public class ESSearchBuilder {
    private QueryContext queryContext = new QueryContext();

    public ESSearchBuilder addCondition(String field, OperatorType type, Object ... values) {
        this.addContext(field, type, QueryQuota.CONDITION, values);
        return this;
    }

    public ESSearchBuilder and() {
        this.addContext(null, null, QueryQuota.AND, new Object[0]);
        return this;
    }

    private void addContext(String field, OperatorType type, QueryQuota queryQuota, Object ... values) {
        OperatorContext context = new OperatorContext();
        context.setFieldName(field);
        context.setQueryQuota(queryQuota);
        context.setValues(values);
        context.setOperateType(type);
        this.queryContext.addContext(context);
    }

    public ESSearchBuilder or() {
        this.addContext(null, null, QueryQuota.OR, new Object[0]);
        return this;
    }

    public ESSearchBuilder startInnerCondition() {
        this.addContext(null, null, QueryQuota.LT, new Object[0]);
        return this;
    }

    public ESSearchBuilder endInnerCondition() {
        this.addContext(null, null, QueryQuota.GT, null);
        return this;
    }

    public ESSearchBuilder scrollId(String scrollId) {
        this.queryContext.scrollId(scrollId);
        return this;
    }

    public ESSearchBuilder from(Integer from) {
        this.queryContext.from(from);
        return this;
    }

    public ESSearchBuilder scrollTimeout(long minute) {
        this.queryContext.scrollTimeout(minute);
        return this;
    }

    public ESSearchBuilder size(Integer size) {
        this.queryContext.size(size);
        return this;
    }

    public ESSearchBuilder indexNames(String[] indexNames) {
        this.queryContext.indexNames(indexNames);
        return this;
    }

    public ESSearchBuilder excludeFields(String[] excludeFields) {
        this.queryContext.excludeFields(excludeFields);
        return this;
    }

    public ESSearchBuilder includeFields(String[] includeFields) {
        this.queryContext.includeFields(includeFields);
        return this;
    }

    public ESSearchBuilder order(String field, OrderType orderType) {
        this.queryContext.addOrder(new ESOrder(field, orderType));
        return this;
    }

    public ESSearchBuilder all() {
        return this;
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }
}

