/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.elasticsearch.server;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexResponse;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mhuang.pacebox.core.check.CheckAssert;
import tech.mhuang.pacebox.elasticsearch.admin.factory.IESFactory;
import tech.mhuang.pacebox.elasticsearch.server.annoation.ESTable;
import tech.mhuang.pacebox.elasticsearch.server.query.AbstractESQuery;
import tech.mhuang.pacebox.elasticsearch.server.query.DefaultESQuery;
import tech.mhuang.pacebox.elasticsearch.server.query.ESSearchBuilder;

public class ESFactory
implements IESFactory {
    private String name;
    private ElasticsearchClient client;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setClient(ElasticsearchClient client) {
        this.client = client;
    }

    @Override
    public ESSearchBuilder getBuilder() {
        return new ESSearchBuilder();
    }

    @Override
    public AbstractESQuery getQuery() {
        return new DefaultESQuery(this.client);
    }

    @Override
    public <T> IndexResponse insert(T t) throws IOException {
        ESTable esTable = this.checkESTable(t);
        return this.insert(t, esTable.index());
    }

    @Override
    public <T> IndexResponse insert(T t, String index) throws IOException {
        return this.insert(this.packEntity(t), index);
    }

    @Override
    public IndexResponse insert(String data, String index) throws IOException {
        return this.baseInsert(data, index);
    }

    private <T> String packEntity(T t) {
        return JSON.toJSONString(t);
    }

    private IndexResponse baseInsert(String data, String index) throws IOException {
        this.logger.debug("===\u6b63\u5728\u63d2\u5165ES\u6570\u636e=====");
        this.logger.debug("\u653e\u5165\u5f97ES\u6570\u636e\u4e3a{}", (Object)data);
        JSONObject jsonObject = JSON.parseObject((String)data);
        IndexRequest indexRequest = IndexRequest.of(i -> i.index(index).document((Object)jsonObject));
        IndexResponse response = this.client.index(indexRequest);
        this.logger.debug("===\u653e\u5165ES\u6570\u636e\u5b8c\u6bd5=====,response:{}", (Object)response);
        return response;
    }

    private <T> ESTable checkESTable(T model) {
        ESTable esTable = null;
        if (model.getClass().isAnnotationPresent(ESTable.class)) {
            esTable = model.getClass().getAnnotation(ESTable.class);
        }
        assert (esTable != null);
        return (ESTable)CheckAssert.check(esTable, (Object)"\u5f53\u524d\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e0d\u662fES\u5bf9\u8c61");
    }

    @Override
    public <T> UpdateResponse update(T t, String id) throws IOException {
        ESTable esTable = this.checkESTable(t);
        return this.update(t, esTable.index(), id);
    }

    @Override
    public <T> UpdateResponse update(T t, String index, String id) throws IOException {
        return this.update(this.packEntity(t), index, id);
    }

    @Override
    public AcknowledgedResponse delete(String index) throws IOException {
        this.logger.debug("===\u6b63\u5728\u5220\u9664ES\u6570\u636e=====,index:{}", (Object)index);
        DeleteIndexRequest deleteRequest = DeleteIndexRequest.of(d -> d.index(index, new String[0]));
        DeleteIndexResponse response = this.client.indices().delete(deleteRequest);
        this.logger.debug("===\u5220\u9664ES\u6570\u636e\u5b8c\u6bd5=====,response:{}", (Object)response);
        return response;
    }

    @Override
    public DeleteResponse delete(String index, String id) throws IOException {
        this.logger.debug("===\u6b63\u5728\u5220\u9664ES\u6570\u636e=====,index:{},id:{}", (Object)index, (Object)id);
        DeleteRequest deleteRequest = DeleteRequest.of(d -> d.index(index).id(id));
        DeleteResponse response = this.client.delete(deleteRequest);
        this.logger.debug("===\u5220\u9664ES\u6570\u636e\u5b8c\u6bd5=====,response:{}", (Object)response);
        return response;
    }

    @Override
    public UpdateResponse update(String data, String index, String id) throws IOException {
        return this.baseUpdate(data, index, id);
    }

    private UpdateResponse baseUpdate(String data, String index, String id) throws IOException {
        this.logger.debug("===\u6b63\u5728\u4fee\u6539ES\u6570\u636e=====");
        this.logger.debug("\u4fee\u6539ES\u6570\u636e\u4e3a{}\uff0cid\u4e3a:{}", (Object)data, (Object)id);
        JSONObject jsonObject = JSON.parseObject((String)data);
        UpdateRequest updateRequest = UpdateRequest.of(u -> u.index(index).id(id).doc((Object)jsonObject));
        UpdateResponse response = this.client.update(updateRequest, JSONObject.class);
        this.logger.debug("\u6253\u5370\u5e94\u7b54\u7684\u6570\u636e\u662f:{}", (Object)response);
        return response;
    }

    @Override
    public ElasticsearchClient getClient() {
        return this.client;
    }
}

