/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.elasticsearch.server.query;

import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mhuang.pacebox.elasticsearch.server.query.ESQueryAware;
import tech.mhuang.pacebox.elasticsearch.server.query.OperatorContext;

public abstract class AbstractESQueryAware
implements ESQueryAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractESQueryAware.class);

    protected void checkValue(int length, OperatorContext context) {
        if (context.getValues().length < length) {
            throw new IllegalArgumentException(context.getFieldName().concat(" values argument length less than ").concat("" + length));
        }
        for (Object value : context.getValues()) {
            if (value != null) continue;
            throw new IllegalArgumentException(context.getFieldName().concat(" exists argument value  is null "));
        }
    }

    protected String getCalcMessage(OperatorContext second) {
        MessageFormat format = new MessageFormat(second.getOperateType().getMessage());
        Object[] messages = new Object[second.getValues().length + 1];
        messages[0] = second.getFieldName();
        System.arraycopy(second.getValues(), 0, messages, 1, second.getValues().length);
        return format.format(messages);
    }
}

