/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.elasticsearch.server.query;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mhuang.pacebox.elasticsearch.model.query.ESPage;
import tech.mhuang.pacebox.elasticsearch.server.query.AbstractESQuery;
import tech.mhuang.pacebox.elasticsearch.server.query.AbstractESQueryAware;
import tech.mhuang.pacebox.elasticsearch.server.query.ESQueryAware;
import tech.mhuang.pacebox.elasticsearch.server.query.QueryContext;

public class DefaultESQuery
extends AbstractESQuery {
    private static final Logger log = LoggerFactory.getLogger(DefaultESQuery.class);

    public DefaultESQuery(ElasticsearchClient client) {
        super(client);
    }

    @Override
    public ESQueryAware query(QueryContext queryContext) {
        return new DefaultEsQueryResult(queryContext, this.client);
    }

    static class DefaultEsQueryResult
    extends AbstractESQueryAware {
        private final QueryContext queryContext;
        private final ElasticsearchClient client;

        DefaultEsQueryResult(QueryContext queryContext, ElasticsearchClient client) {
            this.queryContext = queryContext;
            this.client = client;
        }

        @Override
        public <T> List<T> list(Class<T> clz) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public <T> ESPage<T> page(Class<T> clz) {
            return new ESPage();
        }

        @Override
        public <T> T get(Class<T> clz) {
            this.queryContext.size(1);
            List<T> results = this.list(clz);
            return results.size() == 0 ? null : (T)results.get(0);
        }
    }
}

