/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.exception;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import tech.mhuang.pacebox.springboot.core.exception.BusinessException;
import tech.mhuang.pacebox.springboot.protocol.Result;

@ControllerAdvice
public class CommonExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Result<?> defaultErrorHandler(HttpServletRequest request, Exception e) {
        this.logger.error("---Exception Handler---Host {} invokes url {} ERROR: {}", new Object[]{request.getRemoteHost(), request.getRequestURL(), e.getMessage(), e});
        Result result = new Result();
        if (e instanceof BusinessException) {
            BusinessException business = (BusinessException)e;
            result.setCode(business.getCode());
            result.setMessage(business.getMessage());
        } else {
            result.setCode(500);
            result.setMessage("\u670d\u52a1\u5668\u5f02\u5e38");
        }
        result.setExceptionMsg((Object)e.getStackTrace());
        return result;
    }
}

