/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.spring.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.ClassUtils;
import tech.mhuang.pacebox.core.util.CollectionUtil;

public class DataUtil {
    private static final Logger logger = LoggerFactory.getLogger(DataUtil.class);

    public static <E> List<E> copyTo(List<?> source, Class<E> destinationClass) {
        return DataUtil.copyTo(source, destinationClass, (String[])null);
    }

    public static <E> List<E> copyTo(List<?> source, Class<E> destinationClass, String ... ignore) {
        if (CollectionUtil.isEmpty(source)) {
            return Collections.emptyList();
        }
        ArrayList res = new ArrayList(source.size());
        source.stream().forEach(o -> {
            try {
                Object e = destinationClass.newInstance();
                BeanUtils.copyProperties((Object)o, e, (String[])ignore);
                res.add(e);
            }
            catch (Exception e) {
                logger.error("copy\u6570\u636e\u5f02\u5e38\u5931\u8d25", (Throwable)e);
            }
        });
        return res;
    }

    public static <E> E copyTo(Object source, Class<E> destinationClass) {
        return DataUtil.copyTo(source, destinationClass, (String[])null);
    }

    public static <E> E copyTo(Object source, Class<E> destinationClass, String ... ignore) {
        try {
            E e = destinationClass.newInstance();
            BeanUtils.copyProperties((Object)source, e, (String[])ignore);
            return e;
        }
        catch (Exception e) {
            logger.error("copy\u6570\u636e\u5f02\u5e38\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static <E> E getValueByModelKey(Object model, String key, Class<E> valueClass) throws InvocationTargetException, IllegalAccessException {
        Method readMethod;
        Object result = null;
        Class<?> source = model.getClass();
        PropertyDescriptor sourceKeyPd = BeanUtils.getPropertyDescriptor(source, (String)key);
        if (sourceKeyPd != null && (readMethod = sourceKeyPd.getReadMethod()) != null) {
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                readMethod.setAccessible(true);
            }
            result = readMethod.invoke(model, new Object[0]);
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                readMethod.setAccessible(false);
            }
        }
        return (E)result;
    }

    public static void setValueByModel(Object model, String key, Object value) throws InvocationTargetException, IllegalAccessException {
        Method writeMethod;
        PropertyDescriptor sourceKeyPd = BeanUtils.getPropertyDescriptor(model.getClass(), (String)key);
        if (sourceKeyPd != null && (writeMethod = sourceKeyPd.getWriteMethod()) != null) {
            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(model, value);
            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                writeMethod.setAccessible(false);
            }
        }
    }

    public static <E> E copyToKeyValue(List<?> sourceList, Class<E> destinationClass, String fieldKey, String fieldValue) {
        try {
            PropertyDescriptor[] targetPds;
            E e = destinationClass.newInstance();
            if (CollectionUtil.isEmpty(sourceList)) {
                return null;
            }
            Class<?> target = e.getClass();
            for (PropertyDescriptor targetPd : targetPds = BeanUtils.getPropertyDescriptors(target)) {
                Method writeMethod = targetPd.getWriteMethod();
                if (writeMethod == null) continue;
                for (Object obj : sourceList) {
                    PropertyDescriptor sourcePd;
                    Method readMethod;
                    Class<?> source = obj.getClass();
                    PropertyDescriptor sourceKeyPd = BeanUtils.getPropertyDescriptor(source, (String)fieldKey);
                    if (sourceKeyPd == null || (readMethod = sourceKeyPd.getReadMethod()) == null) continue;
                    if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                        readMethod.setAccessible(true);
                    }
                    Object key = readMethod.invoke(obj, new Object[0]);
                    String setMethod = writeMethod.getName();
                    setMethod = key.toString().charAt(0) + setMethod.substring(4);
                    if (!Objects.equals(key, setMethod) || (sourcePd = BeanUtils.getPropertyDescriptor(source, (String)fieldValue)) == null) continue;
                    Method readValueMethod = sourcePd.getReadMethod();
                    if (readMethod == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readValueMethod.getReturnType())) continue;
                    try {
                        if (!Modifier.isPublic(readValueMethod.getDeclaringClass().getModifiers())) {
                            readValueMethod.setAccessible(true);
                        }
                        Object value = readValueMethod.invoke(obj, new Object[0]);
                        if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                            writeMethod.setAccessible(true);
                        }
                        writeMethod.invoke(e, value);
                    }
                    catch (Throwable ex) {
                        throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
                    }
                }
            }
            return e;
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u590d\u5236\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static void copyTo(Object source, Object target) {
        try {
            BeanUtils.copyProperties((Object)source, (Object)target);
        }
        catch (Exception e) {
            logger.error("copy\u6570\u636e\u5f02\u5e38\u5931\u8d25", (Throwable)e);
        }
    }
}

