/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.task;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import tech.mhuang.pacebox.core.date.DateTimeUtil;
import tech.mhuang.pacebox.core.timer.SystemClock;
import tech.mhuang.pacebox.springboot.core.task.ISingleDymanicTask;
import tech.mhuang.pacebox.springboot.core.task.SingleInterjob;

public class SingleDymanicTask
implements ISingleDymanicTask {
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    private Map<String, SingleInterjob> interJobMap = new ConcurrentHashMap<String, SingleInterjob>();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Boolean startJob(String jobName, Runnable run, String conn) {
        return this.startJob(jobName, run, conn, (Boolean)true);
    }

    @Override
    public Boolean startJobOnly(String jobName, Runnable run, Date date) {
        this.logger.debug("\u6b63\u5728\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u65f6\u95f4\u662f:{}", (Object)jobName, (Object)date);
        Boolean result = false;
        if (!this.interJobMap.containsKey(jobName)) {
            this.logger.debug("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u8868\u8fbe\u5f0f\u65f6\u95f4\u662f:{}", (Object)jobName, (Object)date);
            ScheduledFuture future = this.threadPoolTaskScheduler.schedule(run, date);
            this.interJobMap.put(jobName, new SingleInterjob(future, run, null, null));
            result = true;
        }
        this.logger.debug("\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u65f6\u95f4\u662f:{}\u5b8c\u6210", (Object)jobName, (Object)date);
        return result;
    }

    @Override
    public Boolean startJobOnly(String jobName, Runnable run, String cron) {
        CronSequenceGenerator generator = new CronSequenceGenerator(cron);
        Date date = generator.next(DateTimeUtil.currentDate());
        return this.startJobOnly(jobName, run, date);
    }

    @Override
    public Boolean startJobOnly(String jobName, Runnable run, Long peroid) {
        Long currentTime = SystemClock.now();
        currentTime = currentTime + peroid;
        Date date = new Date(currentTime);
        return this.startJobOnly(jobName, run, date);
    }

    @Override
    public Boolean startJob(String jobName, Runnable run, String conn, Boolean real) {
        this.logger.debug("\u6b63\u5728\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u8868\u8fbe\u5f0f\u65f6\u95f4\u662f:{}", (Object)jobName, (Object)conn);
        Boolean result = false;
        if (!this.interJobMap.containsKey(jobName)) {
            this.logger.debug("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u8868\u8fbe\u5f0f\u65f6\u95f4\u662f:{}", (Object)jobName, (Object)conn);
            ScheduledFuture future = this.threadPoolTaskScheduler.schedule(run, triggerContext -> {
                Date nextTime;
                SingleInterjob interJob = this.interJobMap.get(jobName);
                String nextCron = conn;
                if (interJob != null) {
                    nextCron = interJob.getCron();
                }
                if (triggerContext.lastCompletionTime() == null && !real.booleanValue()) {
                    CronSequenceGenerator generator = new CronSequenceGenerator(nextCron);
                    nextTime = generator.next(DateTimeUtil.currentDate());
                } else {
                    nextTime = new CronTrigger(nextCron).nextExecutionTime(triggerContext);
                }
                this.logger.debug("\u4efb\u52a1\u540d\u79f0:{},\u4e0b\u6b21\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4:{}", (Object)jobName, (Object)nextTime);
                return nextTime;
            });
            this.interJobMap.put(jobName, new SingleInterjob(future, run, conn, null));
            result = true;
        }
        this.logger.debug("\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u8868\u8fbe\u5f0f\u65f6\u95f4\u662f:{}\u5b8c\u6210", (Object)jobName, (Object)conn);
        return result;
    }

    @Override
    public Boolean startJob(String jobName, Runnable run, Long period, Boolean real) {
        this.logger.debug("\u6b63\u5728\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u4e0b\u6b21\u6267\u884c\u7684\u79d2\u6570\u662f:{}", (Object)jobName, (Object)period);
        Boolean result = false;
        if (!this.interJobMap.containsKey(jobName)) {
            this.logger.debug("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u4e0b\u6b21\u6267\u884c\u7684\u79d2\u6570\u662f:{}", (Object)jobName, (Object)period);
            ScheduledFuture future = this.threadPoolTaskScheduler.schedule(run, triggerContext -> {
                SingleInterjob interJob = this.interJobMap.get(jobName);
                Long nexPeriod = period;
                if (interJob != null) {
                    nexPeriod = interJob.getPeriod();
                }
                Date nextTime = triggerContext.lastCompletionTime() == null && real == false ? new Date(SystemClock.now() + nexPeriod) : new PeriodicTrigger(nexPeriod.longValue()).nextExecutionTime(triggerContext);
                this.logger.debug("\u4efb\u52a1\u540d\u79f0:{},\u4e0b\u6b21\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4:{}", (Object)jobName, (Object)nextTime);
                return nextTime;
            });
            this.interJobMap.put(jobName, new SingleInterjob(future, run, null, period));
            result = true;
        }
        this.logger.debug("\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u4e0b\u6b21\u6267\u884c\u7684\u79d2\u6570\u662f:{}\u5b8c\u6210", (Object)jobName, (Object)period);
        return result;
    }

    @Override
    public Boolean startJob(String jobName, Runnable run, Long period) {
        return this.startJob(jobName, run, period, (Boolean)true);
    }

    @Override
    public Boolean stopJob(String jobName) {
        this.logger.debug("\u6b63\u5728\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1:{}", (Object)jobName);
        Boolean result = false;
        if (this.interJobMap.containsKey(jobName)) {
            this.logger.debug("\u6b63\u5728\u6267\u884c\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1:{}", (Object)jobName);
            SingleInterjob job = this.interJobMap.remove(jobName);
            job.getFuture().cancel(true);
            this.interJobMap.remove(jobName);
            result = true;
        }
        this.logger.debug("\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1:{}\u5b8c\u6210", (Object)jobName);
        return result;
    }

    @Override
    public Boolean updateCronLazy(String jobName, String cron) {
        this.logger.debug("\u6b63\u5728\u6267\u884c\u4fee\u6539\u4efb\u52a1\u65f6\u95f4,\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u8868\u8fbe\u5f0f\u65f6\u95f4\u662f:{}", (Object)jobName, (Object)cron);
        Boolean result = false;
        if (this.interJobMap.containsKey(jobName)) {
            SingleInterjob interJob = this.interJobMap.get(jobName);
            this.logger.debug("\u627e\u5230\u4efb\u52a1\uff1a{}\uff0c\u6267\u884c\u65f6\u95f4\u8986\u76d6\u8986\u76d6\uff0c\u65e7\u7684\u65f6\u95f4\u4e3a\uff1a{}", (Object)jobName, (Object)interJob.getCron());
            interJob.setCron(cron);
            this.interJobMap.put(jobName, interJob);
            result = true;
            this.logger.info("task update cron success,cron:{}", (Object)cron);
        }
        this.logger.debug("\u6267\u884c\u4fee\u6539\u4efb\u52a1\u65f6\u95f4,\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u8868\u8fbe\u5f0f\u65f6\u95f4\u662f:{}\u6210\u529f", (Object)jobName, (Object)cron);
        return result;
    }

    @Override
    public Boolean updateSecordsLazy(String jobName, Long period) {
        this.logger.debug("\u6b63\u5728\u6267\u884c\u4fee\u6539\u4efb\u52a1\u65f6\u95f4,\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u4e0b\u6b21\u6267\u884c\u7684\u79d2\u6570\u662f:{}", (Object)jobName, (Object)period);
        Boolean result = false;
        if (this.interJobMap.containsKey(jobName)) {
            SingleInterjob interJob = this.interJobMap.get(jobName);
            this.logger.debug("\u627e\u5230\u4efb\u52a1\uff1a{}\uff0c\u6267\u884c\u65f6\u95f4\u8986\u76d6\u8986\u76d6\uff0c\u65e7\u7684\u65f6\u95f4\u4e3a\uff1a{}", (Object)jobName, (Object)interJob.getPeriod());
            interJob.setPeriod(period);
            this.interJobMap.put(jobName, interJob);
            result = true;
            this.logger.info("task update secord success,secord:{}", (Object)period);
        }
        this.logger.debug("\u6267\u884c\u4fee\u6539\u4efb\u52a1\u65f6\u95f4,\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u8868\u8fbe\u5f0f\u65f6\u95f4\u662f:{}\u6210\u529f", (Object)jobName, (Object)period);
        return result;
    }

    @Override
    public Boolean updateJob(String jobName, String cron) {
        Boolean result = false;
        if (this.interJobMap.containsKey(jobName)) {
            result = this.updateJob(jobName, this.interJobMap.get(jobName).getRunnable(), cron);
        }
        return result;
    }

    @Override
    public Boolean updateJob(String jobName, Long secord) {
        Boolean result = false;
        if (this.interJobMap.containsKey(jobName)) {
            result = this.updateJob(jobName, this.interJobMap.get(jobName).getRunnable(), secord);
        }
        return result;
    }

    @Override
    public Boolean updateJob(String jobName, Runnable run) {
        Boolean result = false;
        if (this.interJobMap.containsKey(jobName)) {
            result = this.updateJob(jobName, run, this.interJobMap.get(jobName).getCron());
        }
        return result;
    }

    @Override
    public Boolean updateJob(String jobName, Runnable run, String conn) {
        this.logger.debug("\u6b63\u5728\u6267\u884c\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u8868\u8fbe\u5f0f\u65f6\u95f4\u662f:{}", (Object)jobName, (Object)conn);
        Boolean result = this.stopJob(jobName);
        if (result.booleanValue()) {
            result = this.startJob(jobName, run, conn, (Boolean)false);
        }
        this.logger.debug("\u6267\u884c\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u8868\u8fbe\u5f0f\u65f6\u95f4\u662f:{}\u5b8c\u6210", (Object)jobName, (Object)conn);
        return result;
    }

    @Override
    public Boolean updateJob(String jobName, Runnable run, Long secord) {
        this.logger.debug("\u6b63\u5728\u6267\u884c\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u4e0b\u6b21\u6267\u884c\u7684\u79d2\u6570\u662f:{}", (Object)jobName, (Object)secord);
        Boolean result = this.stopJob(jobName);
        if (result.booleanValue()) {
            result = this.startJob(jobName, run, secord, (Boolean)false);
        }
        this.logger.debug("\u6267\u884c\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1:{}\uff0c\u4e0b\u6b21\u6267\u884c\u7684\u79d2\u6570\u662f:{}\u5b8c\u6210", (Object)jobName, (Object)secord);
        return result;
    }

    @Override
    public void addThreadPoolTaskScheduler(ThreadPoolTaskScheduler singlePoolTask) {
        this.threadPoolTaskScheduler = singlePoolTask;
    }
}

