/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.controller;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.time.LocalDate;
import java.util.Date;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import tech.mhuang.pacebox.core.date.DateTimeUtil;
import tech.mhuang.pacebox.core.util.StringUtil;

public abstract class BaseController {
    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtil.isEmpty((CharSequence)text)) {
                    return;
                }
                try {
                    this.setValue(DateTimeUtil.parseDateTimeToDate((String)text));
                }
                catch (Exception e) {
                    this.setValue(DateTimeUtil.localDateToStartDate((LocalDate)LocalDate.parse(text)));
                }
            }
        });
    }

    public String redirect(String url) {
        return new StringBuilder(url.length() + 10).append("redirect").append(url).toString();
    }
}

