/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.exception;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import tech.mhuang.pacebox.core.exception.BusinessException;
import tech.mhuang.pacebox.core.exception.ExceptionUtil;
import tech.mhuang.pacebox.springboot.protocol.Result;

@ControllerAdvice
public class CommonExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${pacebox.exception.debug:false}")
    private Boolean debug;
    @Value(value="${system.error.message:\u670d\u52a1\u5668\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458}")
    private String systemErrorMessage;
    @Value(value="${not.support.error.message:\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f}")
    private String notSupportedMessage;

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Result defaultErrorHandler(HttpServletRequest request, Exception e) {
        String message;
        this.logger.error("---Exception Handler---Host {} invokes url {} ERROR: {}", new Object[]{request.getRemoteHost(), request.getRequestURL(), e.getMessage(), e});
        Result result = new Result();
        Integer code = 500;
        String field = null;
        if (e instanceof BusinessException) {
            BusinessException business = (BusinessException)e;
            code = business.getCode();
            message = business.getMessage();
        } else if (e instanceof BindException) {
            field = ((ObjectError)((BindException)e).getAllErrors().get(0)).getCode();
            message = ((ObjectError)((BindException)e).getAllErrors().get(0)).getDefaultMessage();
        } else if (e instanceof MethodArgumentNotValidException) {
            field = ((MethodArgumentNotValidException)e).getBindingResult().getFieldError().getField();
            message = ((MethodArgumentNotValidException)e).getBindingResult().getFieldError().getDefaultMessage();
        } else {
            message = e instanceof HttpRequestMethodNotSupportedException ? this.notSupportedMessage + request.getMethod() : this.systemErrorMessage;
        }
        result.setField(field);
        result.setCode(code.intValue());
        result.setMessage(message);
        if (this.debug.booleanValue()) {
            result.setExceptionMsg((Object)ExceptionUtil.getMessage((Throwable)e));
        }
        return result;
    }
}

