/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.protocol.tree;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import tech.mhuang.pacebox.core.util.CollectionUtil;
import tech.mhuang.pacebox.core.util.StringUtil;
import tech.mhuang.pacebox.springboot.protocol.data.BaseTreeNode;

public class TreeNodeUtil {
    public static List<BaseTreeNode> assembleTree(List<BaseTreeNode> nodeList) {
        if (CollectionUtil.isEmpty(nodeList)) {
            return null;
        }
        List<BaseTreeNode> rstList = nodeList.stream().filter(node -> StringUtil.isEmpty((CharSequence)node.getParentId())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(rstList)) {
            return null;
        }
        rstList.stream().forEach(rst -> TreeNodeUtil.assembleTree(rst, nodeList));
        return rstList;
    }

    public static BaseTreeNode assembleTree(String id, List<BaseTreeNode> nodeList) {
        if (CollectionUtil.isEmpty(nodeList)) {
            return null;
        }
        Optional<BaseTreeNode> optionalBaseTreeNode = nodeList.stream().filter(node -> id.equals(node.getId())).findAny();
        if (optionalBaseTreeNode.isPresent()) {
            return TreeNodeUtil.assembleTree(optionalBaseTreeNode.get(), nodeList);
        }
        return null;
    }

    public static BaseTreeNode assembleTree(BaseTreeNode node, List<BaseTreeNode> nodeList) {
        if (CollectionUtil.isEmpty(nodeList)) {
            return node;
        }
        List<BaseTreeNode> childrenList = nodeList.stream().filter(children -> StringUtil.equals((CharSequence)node.getId(), (CharSequence)children.getParentId())).collect(Collectors.toList());
        childrenList.forEach(children -> TreeNodeUtil.assembleTree(children, nodeList));
        node.setChildren(childrenList);
        return node;
    }
}

