/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.rest;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import tech.mhuang.pacebox.core.file.FileUtil;
import tech.mhuang.pacebox.core.util.CollectionUtil;
import tech.mhuang.pacebox.core.util.ObjectUtil;
import tech.mhuang.pacebox.core.util.StringUtil;
import tech.mhuang.pacebox.springboot.core.entity.RequestModel;
import tech.mhuang.pacebox.springboot.core.rest.ExtractMappingJackson2HttpMessageConverter;

public abstract class AbstractRestTemplate
extends RestTemplate {
    public AbstractRestTemplate() {
    }

    public AbstractRestTemplate(ClientHttpRequestFactory requestFactory) {
        super((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory(requestFactory));
        this.getMessageConverters().add(new ExtractMappingJackson2HttpMessageConverter());
    }

    public ResponseEntity request(RequestModel model) {
        ResponseEntity response = null;
        HttpMethod method = model.getMethod();
        String url = model.getUrl();
        String sufUrl = model.getSufUrl();
        Map<String, String> headerParamMap = model.getHeaderParamMap();
        Object params = model.getParams();
        HttpHeaders headers = new HttpHeaders();
        headers.setAll(headerParamMap);
        if (StringUtil.isNotBlank((CharSequence)sufUrl)) {
            url = url.concat(sufUrl);
        }
        if (method.equals((Object)HttpMethod.GET) || method.equals((Object)HttpMethod.DELETE)) {
            Map tempData;
            LinkedMultiValueMap value = new LinkedMultiValueMap();
            if (ObjectUtil.isNotEmpty((Object)params) && CollectionUtil.isNotEmpty((Map)(tempData = params instanceof Map ? (Map)params : BeanMap.create((Object)params)))) {
                tempData.forEach((arg_0, arg_1) -> AbstractRestTemplate.lambda$request$0((MultiValueMap)value, arg_0, arg_1));
            }
            url = UriComponentsBuilder.fromHttpUrl((String)url).queryParams((MultiValueMap)value).build().toUriString();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            response = this.exchange(url, method, entity, model.getTypeReference(), new Object[0]);
        } else if (method == HttpMethod.PUT || method == HttpMethod.POST) {
            headers.setContentType(model.getMediaType());
            HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
            response = this.exchange(url, method, request, model.getTypeReference(), new Object[0]);
        }
        return response;
    }

    public ByteArrayResource convertFileToByteArrayResource(final File file) throws IOException {
        return new ByteArrayResource(FileUtil.readFileToByteArray((File)file)){

            public String getFilename() {
                return file.getName();
            }
        };
    }

    private static /* synthetic */ void lambda$request$0(MultiValueMap value, Object k, Object v) {
        String tempKey = k instanceof String || ObjectUtil.isEmpty((Object)k) ? (String)k : JSON.toJSONString((Object)k);
        String tempValue = v instanceof String || ObjectUtil.isEmpty((Object)v) ? (String)v : JSON.toJSONString((Object)v);
        value.add((Object)tempKey, (Object)tempValue);
    }
}

