/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.spring.start;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import tech.mhuang.pacebox.core.util.CollectionUtil;

public class SpringContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static DefaultListableBeanFactory beanFactory;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (SpringContextHolder.applicationContext == null) {
            SpringContextHolder.applicationContext = applicationContext;
            beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        }
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)applicationContext.getBean(name, clazz);
    }

    public static void removeBean(String name) {
        beanFactory.removeBeanDefinition(name);
    }

    public static <T> T registerBean(String beanName, Class<T> clazz) {
        return SpringContextHolder.registerBean(beanName, clazz, null, null);
    }

    public static <T> T registerBean(String beanName, Class<T> clazz, Map<String, Object> params, Object ... args) {
        if (applicationContext.containsBean(beanName)) {
            Object bean = applicationContext.getBean(beanName);
            if (bean.getClass().isAssignableFrom(clazz)) {
                return (T)bean;
            }
            throw new RuntimeException("BeanName \u91cd\u590d " + beanName);
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        if (CollectionUtil.isNotEmpty(params)) {
            params.forEach((key, value) -> beanDefinitionBuilder.addPropertyValue(key, value));
        }
        if (CollectionUtil.isNotEmpty((Object[])args)) {
            for (Object arg : args) {
                beanDefinitionBuilder.addConstructorArgValue(arg);
            }
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return SpringContextHolder.getBean(beanName, clazz);
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        return applicationContext.getBeansOfType(type);
    }
}

