package tech.mhuang.pacebox.springboot.core.servlet;

import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 请求过滤器
 *
 * @author mhuang
 * @since 1.0.0
 */
public class RequestFilter extends OncePerRequestFilter {

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String contentType = request.getContentType();
        WebServletRequest httpRequest;
        HttpServletResponse httpResponse;
        String method = request.getMethod();
        if ((contentType != null) && (contentType.startsWith("multipart/form-data")) && ("POST".equalsIgnoreCase(method))) {
            httpRequest = new WebRequestHeader(request);
            httpResponse = new WebResponseHeader(response);
        } else {
            httpRequest = new WebRequestStreamHeader(request);
            httpResponse = new WebResponseStreamHeader(response);
        }
        try {
            filterChain.doFilter(httpRequest, httpResponse);
        } finally {
            if (httpResponse instanceof WebResponseStreamHeader) {
                ((WebResponseStreamHeader) httpResponse).copyBodyToResponse();
            }
        }
    }
}
