/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.controller;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import tech.mhuang.pacebox.core.file.FileUtil;
import tech.mhuang.pacebox.springboot.protocol.Result;

public abstract class BaseController {
    public String redirect(String url) {
        return "redirect" + url;
    }

    public <T> Result<T> success(T data) {
        return Result.ok(data);
    }

    public Result faild(String message) {
        return this.status(500, message);
    }

    public Result faild(int code, String message) {
        return this.status(code, message);
    }

    public Result status(int code, String msg) {
        return Result.status((int)code, (String)msg);
    }

    public ResponseEntity<byte[]> download(File file) throws IOException {
        return this.download(file, file.getName());
    }

    public ResponseEntity<byte[]> download(ByteArrayOutputStream outputStream, String fileName) throws UnsupportedEncodingException {
        return this.download(outputStream.toByteArray(), fileName);
    }

    public ResponseEntity<byte[]> download(File file, String fileName) throws IOException {
        return this.download(FileUtil.readFileToByteArray((File)file), fileName);
    }

    public ResponseEntity<byte[]> download(byte[] bytes, String fileName) throws UnsupportedEncodingException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDispositionFormData("attachment", new String(fileName.getBytes(), StandardCharsets.ISO_8859_1));
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED);
    }
}

