/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.permission;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.mhuang.pacebox.core.exception.BusinessException;
import tech.mhuang.pacebox.core.util.StringUtil;
import tech.mhuang.pacebox.springboot.core.permission.annotation.Permission;
import tech.mhuang.pacebox.springboot.core.permission.extra.IPermissionManager;
import tech.mhuang.pacebox.springboot.core.permission.extra.NoLoopPermissionManager;
import tech.mhuang.pacebox.springboot.core.spring.start.SpringContextHolder;

public class PermissionInteceptor
implements MethodInterceptor {
    private final IPermissionManager commonPermissionManager;

    public PermissionInteceptor(IPermissionManager commonPermissionManager) {
        this.commonPermissionManager = commonPermissionManager;
    }

    @Nullable
    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Permission permission = method.getAnnotation(Permission.class);
        IPermissionManager permissionManager = null;
        if (permission.manager() != NoLoopPermissionManager.class) {
            Class<? extends IPermissionManager> permissionManagerClass = permission.manager();
            permissionManager = permissionManagerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (StringUtil.isNotEmpty((CharSequence)permission.beanName())) {
            permissionManager = SpringContextHolder.getBean(permission.beanName(), IPermissionManager.class);
        }
        if (permissionManager == null && (permissionManager = this.commonPermissionManager) == null) {
            throw new BusinessException(500, "\u8bf7\u914d\u7f6e\u6743\u9650\u5904\u7406\u5668");
        }
        permissionManager.permission(permission);
        return invocation.proceed();
    }
}

