/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.protocol.tree;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import tech.mhuang.pacebox.core.util.CollectionUtil;
import tech.mhuang.pacebox.core.util.StringUtil;
import tech.mhuang.pacebox.springboot.protocol.data.BaseTreeNode;

public class TreeNodeUtil {
    public static <T extends BaseTreeNode> List<T> assembleTree(List<T> nodeList) {
        return TreeNodeUtil.assembleTree(null, nodeList);
    }

    public static <T extends BaseTreeNode> List<T> assembleTree(String id, List<T> nodeList) {
        if (CollectionUtil.isEmpty(nodeList)) {
            return null;
        }
        return nodeList.stream().filter(node -> StringUtil.equals((CharSequence)id, (CharSequence)node.getParentId())).map(node -> TreeNodeUtil.assembleTreeChildren(node, nodeList)).sorted(Comparator.comparing(BaseTreeNode::getSorted)).collect(Collectors.toList());
    }

    public static <T extends BaseTreeNode> T assembleTreeChildren(T node, List<T> nodeList) {
        if (CollectionUtil.isEmpty(nodeList)) {
            return node;
        }
        List childrenList = nodeList.stream().filter(children -> StringUtil.equals((CharSequence)node.getId(), (CharSequence)children.getParentId())).map(children -> TreeNodeUtil.assembleTreeChildren(children, nodeList)).sorted(Comparator.comparing(BaseTreeNode::getSorted)).collect(Collectors.toList());
        node.setChildren(childrenList);
        return node;
    }
}

