/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.spring.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import tech.mhuang.pacebox.core.convert.Converter;
import tech.mhuang.pacebox.core.exception.BusinessException;

public class SpringServletUtil {
    public static ServletRequestAttributes getRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }

    public static HttpServletRequest getRequest() {
        return SpringServletUtil.getRequestAttributes().getRequest();
    }

    public static String getParameter(String name) {
        return SpringServletUtil.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        return Converter.str((Object)SpringServletUtil.getParameter(name), (String)defaultValue);
    }

    public static <T> T getParameterAsType(String name, Class<T> clazz) {
        return (T)Converter.convert(clazz, (Object)SpringServletUtil.getParameter(name), null);
    }

    public static HttpSession getSession() {
        return SpringServletUtil.getRequest().getSession();
    }

    public static HttpServletResponse getResponse() {
        return SpringServletUtil.getRequestAttributes().getResponse();
    }

    public static String resultStr(String str) {
        return SpringServletUtil.resultStr(SpringServletUtil.getResponse(), str);
    }

    public static String resultStr(HttpServletResponse response, String str) {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        try {
            response.getWriter().write(str);
        }
        catch (IOException e) {
            throw new BusinessException(500, "\u64cd\u4f5c\u5931\u8d25");
        }
        return null;
    }
}

