/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.aop.config;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import tech.mhuang.pacebox.core.util.CollectionUtil;
import tech.mhuang.pacebox.springboot.core.aop.config.AopConfig;

public class AopConfigParser {
    public static final String AOP = "aop";
    public static final String ADVICE = "advice";
    public static final String EXPRESSION = "expression";
    private String configPath;
    private Properties properties = new Properties();
    private List<AopConfig> configList;

    public AopConfigParser(String configPath) throws IOException {
        this.configPath = configPath;
        this.configList = this.parseConfig(configPath);
    }

    public Map<String, Map<String, String>> parseConfigToMap(String configPath) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(configPath));
        this.properties.load(inputStream);
        Set<Map.Entry<Object, Object>> configSet = this.properties.entrySet();
        Map configMap = (Map)CollectionUtil.capacity(HashMap.class, (int)configSet.size());
        if (CollectionUtil.isNotEmpty(configSet)) {
            configSet.stream().filter(entry -> entry.getKey().toString().toLowerCase().startsWith(AOP)).forEach(entry -> {
                String key = entry.getKey().toString().toLowerCase();
                String val = entry.getValue().toString();
                String[] keys = key.split("\\.");
                Map config = (Map)configMap.get(keys[2]);
                if (CollectionUtil.isEmpty((Map)configMap)) {
                    configMap.put(keys[2], (Map)CollectionUtil.capacity(HashMap.class, (int)4));
                    config = (Map)configMap.get(keys[2]);
                }
                config.put(keys[1], val);
            });
        }
        return configMap;
    }

    public List<AopConfig> parseConfig(String configPath) throws IOException {
        Map<String, Map<String, String>> map = this.parseConfigToMap(configPath);
        ArrayList<AopConfig> configList = new ArrayList<AopConfig>();
        if (CollectionUtil.isNotEmpty(map)) {
            map.forEach((key, val) -> {
                AopConfig config = new AopConfig();
                config.setName((String)key);
                config.setAdvice((String)val.get(ADVICE));
                config.setExpression((String)val.get(EXPRESSION));
                configList.add(config);
            });
        }
        return configList;
    }

    public List<AopConfig> parseConfig() throws IOException {
        return this.parseConfig(this.configPath);
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<AopConfig> getConfigList() {
        return this.configList;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setConfigList(List<AopConfig> configList) {
        this.configList = configList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AopConfigParser)) {
            return false;
        }
        AopConfigParser other = (AopConfigParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$configPath = this.getConfigPath();
        String other$configPath = other.getConfigPath();
        if (this$configPath == null ? other$configPath != null : !this$configPath.equals(other$configPath)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<AopConfig> this$configList = this.getConfigList();
        List<AopConfig> other$configList = other.getConfigList();
        return !(this$configList == null ? other$configList != null : !((Object)this$configList).equals(other$configList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AopConfigParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $configPath = this.getConfigPath();
        result = result * 59 + ($configPath == null ? 43 : $configPath.hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<AopConfig> $configList = this.getConfigList();
        result = result * 59 + ($configList == null ? 43 : ((Object)$configList).hashCode());
        return result;
    }

    public String toString() {
        return "AopConfigParser(configPath=" + this.getConfigPath() + ", properties=" + this.getProperties() + ", configList=" + this.getConfigList() + ")";
    }
}

