/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.okhttp;

import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import tech.mhuang.pacebox.core.exception.BusinessException;
import tech.mhuang.pacebox.core.util.ObjectUtil;
import tech.mhuang.pacebox.core.util.StringUtil;
import tech.mhuang.pacebox.springboot.core.okhttp.TrustAnyTrustManager;

public class OkhttpClientUtil {
    public static OkHttpClient.Builder genOkHttpClient() {
        return OkhttpClientUtil.genOkHttpClient(null, 0);
    }

    public static OkHttpClient.Builder genOkHttpClient(Interceptor interceptor) {
        return OkhttpClientUtil.genOkHttpClient(null, 0, interceptor);
    }

    public static OkHttpClient.Builder genOkHttpClient(String proxyHost, int proxyPort) {
        return OkhttpClientUtil.genOkHttpClient(proxyHost, proxyPort, null, null);
    }

    public static OkHttpClient.Builder genOkHttpClient(String proxyHost, int proxyPort, Interceptor interceptor) {
        return OkhttpClientUtil.genOkHttpClient(proxyHost, proxyPort, null, null, interceptor);
    }

    public static OkHttpClient.Builder genOkHttpClient(String certPath, String certPass) {
        return OkhttpClientUtil.genOkHttpClient(null, 0, certPath, certPass, new TrustAnyTrustManager());
    }

    public static OkHttpClient.Builder genOkHttpClient(String certPath, String certPass, Interceptor interceptor) {
        return OkhttpClientUtil.genOkHttpClient(null, 0, certPath, certPass, new TrustAnyTrustManager(), interceptor);
    }

    public static OkHttpClient.Builder genOkHttpClient(String certPath, String certPass, X509TrustManager trustManager) {
        return OkhttpClientUtil.genOkHttpClient(null, 0, certPath, certPass, trustManager);
    }

    public static OkHttpClient.Builder genOkHttpClient(String certPath, String certPass, X509TrustManager trustManager, Interceptor interceptor) {
        return OkhttpClientUtil.genOkHttpClient(null, 0, certPath, certPass, trustManager, interceptor);
    }

    public static OkHttpClient.Builder genOkHttpClient(String proxyHost, int proxyPort, String certPath, String certPass) {
        return OkhttpClientUtil.genOkHttpClient(Proxy.Type.HTTP, proxyHost, proxyPort, certPath, certPass, new TrustAnyTrustManager(), null);
    }

    public static OkHttpClient.Builder genOkHttpClient(String proxyHost, int proxyPort, String certPath, String certPass, Interceptor interceptor) {
        return OkhttpClientUtil.genOkHttpClient(Proxy.Type.HTTP, proxyHost, proxyPort, certPath, certPass, new TrustAnyTrustManager(), interceptor);
    }

    public static OkHttpClient.Builder genOkHttpClient(String proxyHost, int proxyPort, String certPath, String certPass, X509TrustManager trustManager) {
        return OkhttpClientUtil.genOkHttpClient(Proxy.Type.HTTP, proxyHost, proxyPort, certPath, certPass, trustManager, null);
    }

    public static OkHttpClient.Builder genOkHttpClient(String proxyHost, int proxyPort, String certPath, String certPass, X509TrustManager trustManager, Interceptor interceptor) {
        return OkhttpClientUtil.genOkHttpClient(Proxy.Type.HTTP, proxyHost, proxyPort, certPath, certPass, trustManager, interceptor);
    }

    public static OkHttpClient.Builder genOkHttpClient(Proxy.Type type, String proxyHost, int proxyPort, String certPath, String certPass, Interceptor interceptor) {
        return OkhttpClientUtil.genOkHttpClient(type, proxyHost, proxyPort, certPath, certPass, new TrustAnyTrustManager(), interceptor);
    }

    public static OkHttpClient.Builder genOkHttpClient(Proxy.Type type, String proxyHost, int proxyPort, String certPath, String certPass, X509TrustManager trustManager, Interceptor interceptor) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (StringUtil.isNotEmpty((CharSequence)proxyHost)) {
            clientBuilder.proxy(new Proxy(type, new InetSocketAddress(proxyHost, proxyPort)));
        }
        if (StringUtil.isNotEmpty((CharSequence)certPath)) {
            clientBuilder.sslSocketFactory(OkhttpClientUtil.getSslContext(certPath, certPass).getSocketFactory(), trustManager);
        }
        if (ObjectUtil.isNotEmpty((Object)interceptor)) {
            clientBuilder.addInterceptor(interceptor);
        }
        return clientBuilder;
    }

    public static SSLContext getSslContext(String certPath, String certPass) {
        return OkhttpClientUtil.getSslContext(certPath, certPass, new TrustAnyTrustManager());
    }

    public static SSLContext getSslContext(String certPath, String certPass, TrustManager trustManager) {
        try {
            KeyStore clientStore = KeyStore.getInstance("PKCS12");
            FileInputStream inputStream = new FileInputStream(certPath);
            char[] passArray = certPass.toCharArray();
            clientStore.load(inputStream, passArray);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(clientStore, passArray);
            KeyManager[] kms = kmf.getKeyManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kms, new TrustManager[]{trustManager}, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new BusinessException(500, "\u8bc1\u4e66\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
        }
    }
}

