/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.servlet;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.web.filter.OncePerRequestFilter;
import tech.mhuang.pacebox.springboot.core.servlet.WebRequestHeader;
import tech.mhuang.pacebox.springboot.core.servlet.WebRequestStreamHeader;
import tech.mhuang.pacebox.springboot.core.servlet.WebResponseHeader;
import tech.mhuang.pacebox.springboot.core.servlet.WebResponseStreamHeader;

public class RequestFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletResponse httpResponse;
        HttpServletRequestWrapper httpRequest;
        String contentType = request.getContentType();
        String method = request.getMethod();
        if (contentType != null && contentType.startsWith("multipart/form-data") && "POST".equalsIgnoreCase(method)) {
            httpRequest = new WebRequestHeader(request);
            httpResponse = new WebResponseHeader(response);
        } else {
            httpRequest = new WebRequestStreamHeader(request);
            httpResponse = new WebResponseStreamHeader(response);
        }
        try {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (Throwable throwable) {
            if (httpResponse instanceof WebResponseStreamHeader) {
                httpResponse.copyBodyToResponse();
            }
            throw throwable;
        }
        if (httpResponse instanceof WebResponseStreamHeader) {
            ((WebResponseStreamHeader)httpResponse).copyBodyToResponse();
        }
    }
}

