/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import tech.mhuang.pacebox.core.io.IOUtil;
import tech.mhuang.pacebox.springboot.core.servlet.WebServletInputStream;
import tech.mhuang.pacebox.springboot.core.servlet.WebServletRequest;

public class WebRequestStreamHeader
extends HttpServletRequestWrapper
implements WebServletRequest {
    private final byte[] body;
    private final Map<String, String> customHeaders;
    private final HttpServletRequest request;

    public WebRequestStreamHeader(HttpServletRequest request) throws IOException {
        super(request);
        this.request = request;
        this.customHeaders = new HashMap<String, String>();
        this.body = IOUtil.toByteArray((InputStream)request.getInputStream(), (boolean)false);
    }

    @Override
    public void putHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public String getHeader(String name) {
        String headerValue = this.customHeaders.get(name);
        if (headerValue != null) {
            return headerValue;
        }
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.customHeaders.containsKey(name)) {
            HashSet<String> em = new HashSet<String>();
            em.add(this.customHeaders.get(name));
            return Collections.enumeration(em);
        }
        return this.request.getHeaders(name);
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public String changeSessionId() {
        return this.request.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this.request.authenticate(response);
    }

    public void login(String username, String password) throws ServletException {
        this.request.login(username, password);
    }

    public void logout() throws ServletException {
        this.request.logout();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.request.getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this.request.getPart(name);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        return (T)this.request.upgrade(httpUpgradeHandlerClass);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        return new WebServletInputStream(this.body);
    }
}

