/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.spring.start;

import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import tech.mhuang.pacebox.core.exception.BusinessException;
import tech.mhuang.pacebox.core.util.CollectionUtil;

public class SpringContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static DefaultListableBeanFactory beanFactory;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static BeanFactory getBeanFactory() {
        return beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (SpringContextHolder.applicationContext == null) {
            SpringContextHolder.applicationContext = applicationContext;
            beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        }
    }

    public static boolean containsBean(String name) {
        return applicationContext.containsBean(name);
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)applicationContext.getBean(name, clazz);
    }

    public static void removeBean(String name) {
        beanFactory.removeBeanDefinition(name);
    }

    public static <T> T registerBean(String beanName, Class<T> clazz) {
        return SpringContextHolder.registerBean(beanName, clazz, null, new Object[0]);
    }

    public static <T> T registerBean(String beanName, Class<T> clazz, Map<String, Object> params, Object ... args) {
        if (applicationContext.containsBean(beanName)) {
            Object bean = applicationContext.getBean(beanName);
            if (bean.getClass().isAssignableFrom(clazz)) {
                return (T)bean;
            }
            throw new RuntimeException("BeanName \u91cd\u590d " + beanName);
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        if (CollectionUtil.isNotEmpty(params)) {
            params.forEach((arg_0, arg_1) -> ((BeanDefinitionBuilder)beanDefinitionBuilder).addPropertyValue(arg_0, arg_1));
        }
        if (CollectionUtil.isNotEmpty((Object[])args)) {
            for (Object arg : args) {
                beanDefinitionBuilder.addConstructorArgValue(arg);
            }
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return SpringContextHolder.getBean(beanName, clazz);
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        return applicationContext.getBeansOfType(type);
    }

    public static String getProperty(String key) {
        return SpringContextHolder.getProperty(key, String.class);
    }

    public static String getProperty(String key, String defaultValue) {
        return SpringContextHolder.getProperty(key, String.class, defaultValue);
    }

    public static <T> T getProperty(String key, Class<T> clazz) {
        return SpringContextHolder.getProperty(key, clazz, null);
    }

    public static <T> T getProperty(String key, Class<T> clazz, T defaultValue) {
        return (T)SpringContextHolder.getBean(Environment.class).getProperty(key, clazz, defaultValue);
    }

    public static String getApplicationName() {
        return applicationContext.getApplicationName();
    }

    public static void unregisterBean(String beanName) {
        DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextHolder.getBeanFactory();
        if (!(factory instanceof DefaultSingletonBeanRegistry)) {
            throw new BusinessException("Can not unregister bean, the factory is not a DefaultSingletonBeanRegistry!");
        }
        DefaultSingletonBeanRegistry registry = (DefaultSingletonBeanRegistry)factory;
        registry.destroySingleton(beanName);
    }

    public static void publishEvent(ApplicationEvent event) {
        applicationContext.publishEvent(event);
    }

    public static void publishEvent(Object event) {
        applicationContext.publishEvent(event);
    }
}

