/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.core.util;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import tech.mhuang.pacebox.core.convert.Converter;
import tech.mhuang.pacebox.core.date.DatePattern;

public class IdCardUtil {
    private static final String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static final int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    public static boolean isValidatedAllIdcard(String idcard) {
        if (idcard == null || "".equals(idcard)) {
            return false;
        }
        int s = 15;
        if (idcard.length() == s) {
            return IdCardUtil.validate15IdCard(idcard);
        }
        int s1 = 18;
        if (idcard.length() == s1) {
            return IdCardUtil.validate18Idcard(idcard);
        }
        return false;
    }

    public static boolean validate18Idcard(String idcard) {
        if (idcard == null) {
            return false;
        }
        int s = 18;
        if (idcard.length() != s) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        if (IdCardUtil.isDigital(idcard17)) {
            return false;
        }
        String provinceid = idcard.substring(0, 2);
        if (IdCardUtil.checkProvinceid(provinceid)) {
            return false;
        }
        String birthday = idcard.substring(6, 14);
        try {
            LocalDate localDate = LocalDate.parse(birthday, DatePattern.PURE_DATE_FORMAT);
        }
        catch (DateTimeParseException e1) {
            return false;
        }
        String idcard18Code = idcard.substring(17, 18);
        char[] c = idcard17.toCharArray();
        int[] bit = IdCardUtil.converCharToInt(c);
        int sum17 = IdCardUtil.getPowerSum(bit);
        String checkCode = IdCardUtil.getCheckCodeBySum(sum17);
        if (null == checkCode) {
            return false;
        }
        return idcard18Code.equalsIgnoreCase(checkCode);
    }

    public static boolean validate15IdCard(String idcard) {
        if (idcard == null) {
            return false;
        }
        int s = 15;
        if (idcard.length() != s) {
            return false;
        }
        if (IdCardUtil.isDigital(idcard)) {
            return false;
        }
        String provinceid = idcard.substring(0, 2);
        if (IdCardUtil.checkProvinceid(provinceid)) {
            return false;
        }
        String birthday = idcard.substring(6, 12);
        try {
            LocalDate.parse(birthday, DateTimeFormatter.ofPattern("yyMMdd"));
        }
        catch (DateTimeParseException e1) {
            return false;
        }
        return true;
    }

    public static String convertIdcarBy15bit(String idcard) {
        String year;
        if (idcard == null) {
            return null;
        }
        int s = 15;
        if (idcard.length() != s) {
            return null;
        }
        if (IdCardUtil.isDigital(idcard)) {
            return null;
        }
        String provinceid = idcard.substring(0, 2);
        if (IdCardUtil.checkProvinceid(provinceid)) {
            return null;
        }
        String birthday = idcard.substring(6, 12);
        try {
            LocalDate localDateTime = LocalDate.parse(birthday, DateTimeFormatter.ofPattern("yyMMdd"));
            year = Converter.str((Object)localDateTime.getYear());
        }
        catch (DateTimeParseException e1) {
            return null;
        }
        String idcard17 = idcard.substring(0, 6) + year + idcard.substring(8);
        char[] c = idcard17.toCharArray();
        int[] bit = IdCardUtil.converCharToInt(c);
        int sum17 = IdCardUtil.getPowerSum(bit);
        String checkCode = IdCardUtil.getCheckCodeBySum(sum17);
        if (null == checkCode) {
            return null;
        }
        idcard17 = idcard17 + checkCode;
        return idcard17;
    }

    private static boolean checkProvinceid(String provinceid) {
        for (String id : cityCode) {
            if (!id.equals(provinceid)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDigital(String str) {
        return !str.matches("^[0-9]*$");
    }

    private static int getPowerSum(int[] bit) {
        int sum = 0;
        if (power.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < power.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * power[j];
            }
        }
        return sum;
    }

    private static String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
                break;
            }
        }
        return checkCode;
    }

    private static int[] converCharToInt(char[] c) throws NumberFormatException {
        int[] a = new int[c.length];
        int k = 0;
        for (char temp : c) {
            a[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return a;
    }
}

