/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.redis.commands;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.serializer.RedisSerializer;
import tech.mhuang.pacebox.core.util.CollectionUtil;
import tech.mhuang.pacebox.springboot.redis.commands.IRedisExtCommands;
import tech.mhuang.pacebox.springboot.redis.commands.sets.sorted.RedisSortedSetDTO;

public abstract class AbstractBaseRedisCommands
implements IRedisExtCommands {
    RedisTemplate<String, ?> baseTempalte;
    @Value(value="${spring.redis.database:0}")
    int defaultDbIndex;

    @Override
    public boolean hset(String key, String field, Object value) {
        return this.hset(this.defaultDbIndex, key, field, value);
    }

    @Override
    public boolean hmset(String key, Map<String, Object> params) {
        return this.hmset(this.defaultDbIndex, key, params);
    }

    @Override
    public Collection<String> hmget(String key, Collection<String> fields) {
        return this.hmget(this.defaultDbIndex, key, (Collection)fields);
    }

    @Override
    public Map<String, String> hgetall(String key) {
        return this.hgetall(this.defaultDbIndex, key);
    }

    @Override
    public boolean zadd(String key, double score, Object value) {
        return this.zadd(this.defaultDbIndex, key, score, value);
    }

    @Override
    public boolean set(String key, Object value) {
        return this.set(this.defaultDbIndex, key, value);
    }

    @Override
    public boolean set(String key, Object value, long expireTime) {
        return this.set(this.defaultDbIndex, key, value, expireTime);
    }

    @Override
    public Long incr(String key) {
        return this.incr(this.defaultDbIndex, key);
    }

    @Override
    public String get(String key) {
        return this.get(this.defaultDbIndex, key);
    }

    @Override
    public boolean mset(Map<String, Object> map) {
        return this.mset(this.defaultDbIndex, map);
    }

    @Override
    public Collection<String> mget(Collection<String> keys) {
        return this.mget(this.defaultDbIndex, keys);
    }

    @Override
    public long del(String key) {
        return this.del(this.defaultDbIndex, key);
    }

    @Override
    public long append(int index, String key, Object value) {
        return (Long)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            return connection.append(serializer.serialize((Object)key), serializer.serialize((Object)(value instanceof String ? (String)value : JSON.toJSONString((Object)value))));
        });
    }

    @Override
    public boolean zadd(int index, String key, double score, Object value) {
        return (Boolean)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            String val = value instanceof String ? (String)value : JSON.toJSONString((Object)value);
            return connection.zAdd(serializer.serialize((Object)key), score, serializer.serialize((Object)val));
        });
    }

    @Override
    public boolean hset(int index, String key, String field, Object value) {
        return (Boolean)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            String v = value instanceof String ? (String)value : JSON.toJSONString((Object)value);
            return connection.hSet(serializer.serialize((Object)key), serializer.serialize((Object)field), serializer.serialize((Object)v));
        });
    }

    @Override
    public boolean hmsetList(String key, Map<String, List<Object>> params) {
        if (CollectionUtil.isEmpty(params)) {
            return false;
        }
        HashMap<String, Object> operaterMap = new HashMap<String, Object>(params.size());
        params.forEach((field, value) -> operaterMap.put((String)field, value));
        return this.hmset(key, operaterMap);
    }

    @Override
    public boolean hmsetList(int index, String key, Map<String, List<Object>> params) {
        if (CollectionUtil.isEmpty(params)) {
            return false;
        }
        HashMap<String, Object> operaterMap = new HashMap<String, Object>(params.size());
        params.forEach((field, value) -> operaterMap.put((String)field, value));
        return this.hmset(key, operaterMap);
    }

    @Override
    public boolean hmset(int index, String key, Map<String, Object> params) {
        if (CollectionUtil.isEmpty(params)) {
            return false;
        }
        return (Boolean)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            HashMap hmsetMap = new HashMap(params.size());
            params.forEach((field, value) -> {
                String val = value instanceof String ? (String)value : JSON.toJSONString((Object)value);
                hmsetMap.put(serializer.serialize(field), serializer.serialize((Object)val));
            });
            connection.hMSet(serializer.serialize((Object)key), hmsetMap);
            return true;
        });
    }

    public List<String> hmget(int index, String key, Collection<String> fields) {
        if (CollectionUtil.isEmpty(fields)) {
            return Collections.emptyList();
        }
        return (List)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            List collector = fields.parallelStream().map(value -> serializer.serialize(value)).collect(Collectors.toList());
            List valueList = connection.hMGet(serializer.serialize((Object)key), (byte[][])collector.stream().toArray(x$0 -> new byte[x$0][]));
            return valueList.parallelStream().map(value -> (String)serializer.deserialize(value)).collect(Collectors.toList());
        });
    }

    @Override
    public Map<String, String> hgetall(int index, String key) {
        return (Map)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            Map datas = connection.hGetAll(serializer.serialize((Object)key));
            HashMap result = new HashMap(datas.size());
            datas.forEach((field, value) -> result.put(serializer.deserialize(field), serializer.deserialize(value)));
            return result;
        });
    }

    @Override
    public List<String> hvals(String key) {
        return this.hvals(this.defaultDbIndex, key);
    }

    @Override
    public List<String> hkeys(String key) {
        return this.hkeys(this.defaultDbIndex, key);
    }

    @Override
    public List<String> hkeys(int index, String key) {
        return (List)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            Set valueList = connection.hKeys(serializer.serialize((Object)key));
            return valueList.parallelStream().map(value -> (String)serializer.deserialize(value)).collect(Collectors.toList());
        });
    }

    @Override
    public List<String> hvals(int index, String key) {
        return (List)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            List datas = connection.hVals(serializer.serialize((Object)key));
            return datas.parallelStream().map(value -> (String)serializer.deserialize(value)).collect(Collectors.toList());
        });
    }

    @Override
    public boolean set(int index, String key, Object value) {
        return (Boolean)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            connection.set(serializer.serialize((Object)key), serializer.serialize((Object)(value instanceof String ? (String)value : JSON.toJSONString((Object)value))));
            return true;
        });
    }

    @Override
    public Long incr(int index, String key) {
        return (Long)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            return connection.incr(serializer.serialize((Object)key));
        });
    }

    @Override
    public boolean set(int index, String key, Object value, long expireTime) {
        return (Boolean)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            if (value instanceof String) {
                connection.setEx(serializer.serialize((Object)key), expireTime, serializer.serialize((Object)((String)value)));
            } else {
                connection.setEx(serializer.serialize((Object)key), expireTime, serializer.serialize((Object)JSON.toJSONString((Object)value)));
            }
            return true;
        });
    }

    @Override
    public String get(int index, String key) {
        return (String)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            byte[] value = connection.get(serializer.serialize((Object)key));
            return (String)serializer.deserialize(value);
        });
    }

    @Override
    public boolean mset(int index, Map<String, Object> map) {
        if (CollectionUtil.isEmpty(map)) {
            return false;
        }
        return (Boolean)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            HashMap result = new HashMap(map.size());
            map.forEach((key, value) -> result.put(serializer.serialize(key), serializer.serialize((Object)(value instanceof String ? (String)value : JSON.toJSONString((Object)value)))));
            connection.mSet(result);
            return true;
        });
    }

    @Override
    public Collection<String> mget(int index, Collection<String> keys) {
        if (CollectionUtil.isEmpty(keys)) {
            return Collections.emptyList();
        }
        return (Collection)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            List collector = keys.parallelStream().map(value -> serializer.serialize(value)).collect(Collectors.toList());
            collector = connection.mGet((byte[][])collector.toArray());
            return collector.parallelStream().map(value -> (String)serializer.deserialize(value)).collect(Collectors.toList());
        });
    }

    @Override
    public long append(String key, Object value) {
        return this.append(this.defaultDbIndex, key, value);
    }

    @Override
    public long del(int index, String key) {
        return (Long)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            return connection.del((byte[][])new byte[][]{serializer.serialize((Object)key)});
        });
    }

    @Override
    public String hget(String key, String field) {
        return this.hget(this.defaultDbIndex, key, field);
    }

    @Override
    public String hget(int index, String key, String field) {
        return (String)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            byte[] hGetResult = connection.hGet(serializer.serialize((Object)key), serializer.serialize((Object)field));
            return (String)serializer.deserialize(hGetResult);
        });
    }

    @Override
    public Boolean expire(String key, long seconds) {
        return this.expire(this.defaultDbIndex, key, seconds);
    }

    @Override
    public Boolean expire(int index, String key, long seconds) {
        return (Boolean)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            return connection.expire(serializer.serialize((Object)key), seconds);
        });
    }

    @Override
    public Long hincrby(String key, String field, Long incroment) {
        return this.hincrby(this.defaultDbIndex, key, field, incroment);
    }

    @Override
    public Long hincrby(int index, String key, String field, Long incroment) {
        return (Long)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            return connection.hIncrBy(serializer.serialize((Object)key), serializer.serialize((Object)field), incroment.longValue());
        });
    }

    @Override
    public Long hdel(int index, String key, Object field) {
        return (Long)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            if (field instanceof String) {
                String f = (String)field;
                return connection.hDel(serializer.serialize((Object)key), (byte[][])new byte[][]{serializer.serialize((Object)f)});
            }
            Collection val = (Collection)field;
            byte[][] f = (byte[][])val.parallelStream().map(value -> serializer.serialize((Object)((String)value))).toArray();
            return connection.hDel(serializer.serialize((Object)key), f);
        });
    }

    @Override
    public Long hdel(String key, Object field) {
        return this.hdel(this.defaultDbIndex, key, field);
    }

    @Override
    public Boolean exists(String key) {
        return this.exists(this.defaultDbIndex, key);
    }

    @Override
    public Boolean exists(int index, String key) {
        return (Boolean)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            return connection.exists(serializer.serialize((Object)key));
        });
    }

    @Override
    public double zIncrBy(int index, String key, double score, Object member) {
        return (Double)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            String val = member instanceof String ? (String)member : JSON.toJSONString((Object)member);
            return connection.zIncrBy(serializer.serialize((Object)key), score, serializer.serialize((Object)val));
        });
    }

    @Override
    public <T> List<T> zRevRange(int index, String key, long start, long end, Class<T> clz) {
        return (List)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            Set bytes = connection.zRevRange(serializer.serialize((Object)key), start, end);
            ArrayList list = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)bytes)) {
                bytes.forEach(t -> list.add(JSON.parseObject((String)((String)serializer.deserialize(t)), (Class)clz)));
            }
            return list;
        });
    }

    @Override
    public Long zadd(String key, List<RedisSortedSetDTO> list) {
        return this.zadd(this.defaultDbIndex, key, list);
    }

    @Override
    public Long zadd(int index, String key, List<RedisSortedSetDTO> list) {
        return (Long)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            return connection.zAdd(serializer.serialize((Object)key), list.stream().collect(Collectors.toSet()));
        });
    }

    @Override
    public <T> Set<T> scan(int index, String pattern, int count, Class<T> clazz) {
        return (Set)this.baseTempalte.execute(connection -> {
            connection.select(index);
            RedisSerializer serializer = this.baseTempalte.getStringSerializer();
            HashSet<Object> set = new HashSet<Object>();
            try (Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().match(pattern).count((long)count).build());){
                while (cursor.hasNext()) {
                    set.add(JSON.parseObject((String)((String)serializer.deserialize((byte[])cursor.next())), (Class)clazz));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return set;
        });
    }

    public void setBaseTempalte(RedisTemplate<String, ?> baseTempalte) {
        this.baseTempalte = baseTempalte;
    }
}

