/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.redis.lock;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import tech.mhuang.pacebox.core.util.StringUtil;
import tech.mhuang.pacebox.springboot.redis.lock.Lock;

public class DistributedLockHandler {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockHandler.class);
    private static final long LOCK_EXPIRE = 30000L;
    private static final long LOCK_TRY_INTERVAL = 30L;
    private static final long LOCK_TRY_TIMEOUT = 20000L;
    private StringRedisTemplate template;
    final String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";

    public boolean tryLock(Lock lock) {
        return this.getLock(lock, 20000L, 30L, 30000L, false);
    }

    public boolean tryLock(Lock lock, boolean isOnly) {
        return this.getLock(lock, 20000L, 30L, 30000L, isOnly);
    }

    public boolean tryLock(Lock lock, long timeout) {
        return this.getLock(lock, timeout, 30L, 30000L, false);
    }

    public boolean tryLock(Lock lock, long timeout, long tryInterval) {
        return this.getLock(lock, timeout, tryInterval, 30000L, false);
    }

    public boolean tryLock(Lock lock, long timeout, long tryInterval, long lockExpireTime) {
        return this.getLock(lock, timeout, tryInterval, lockExpireTime, false);
    }

    public boolean getLock(Lock lock, long timeout, long tryInterval, long lockExpireTime, boolean isOnly) {
        try {
            if (StringUtil.isEmpty((CharSequence)lock.getName()) || StringUtil.isEmpty((CharSequence)lock.getValue())) {
                return false;
            }
            do {
                if (Boolean.FALSE.equals(this.template.hasKey((Object)lock.getName()))) {
                    ValueOperations ops = this.template.opsForValue();
                    ops.set((Object)lock.getName(), (Object)lock.getValue(), lockExpireTime, TimeUnit.MILLISECONDS);
                    return true;
                }
                if (isOnly) {
                    return false;
                }
                log.debug("lock[{}] exist!\uff01\uff01", (Object)lock.getName());
                Thread.sleep(tryInterval);
            } while (Boolean.TRUE.equals(this.template.hasKey((Object)lock.getName())));
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public void releaseLock(Lock lock) {
        if (StringUtil.isNotEmpty((CharSequence)lock.getName())) {
            this.template.execute(connection -> {
                RedisSerializer serializer = this.template.getStringSerializer();
                return connection.scriptingCommands().eval(Objects.requireNonNull(serializer.serialize((Object)"if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end")), ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{serializer.serialize((Object)lock.getName()), serializer.serialize((Object)lock.getValue())});
            });
        }
    }

    public void setTemplate(StringRedisTemplate template) {
        this.template = template;
    }
}

