/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.rediskafkamiddle;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import tech.mhuang.pacebox.core.util.StringUtil;
import tech.mhuang.pacebox.kafka.global.exception.JkafkaException;
import tech.mhuang.pacebox.kafka.producer.bean.KafkaMsg;
import tech.mhuang.pacebox.springboot.redis.commands.RedisExtCommands;
import tech.mhuang.pacebox.springboot.redis.lock.DistributedLockHandler;
import tech.mhuang.pacebox.springboot.redis.lock.Lock;
import tech.mhuang.pacebox.springboot.rediskafkamiddle.annaotion.RedisKafka;

@Component
@Aspect
@Order(value=100)
public class RedisKafkaAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String CONSUMER = "-consumer";
    private final String LOCK = "-lock-";
    @Autowired
    private RedisExtCommands redisExtCommands;
    @Autowired
    private DistributedLockHandler distributedLockHandler;
    @Value(value="${redisKafkaDataBase:0}")
    private int redisKafkaDataBase;

    @Pointcut(value="@annotation(tech.mhuang.pacebox.springboot.rediskafkamiddle.annaotion.RedisKafka)")
    private void kafkaMsgProcess() {
    }

    public static Boolean getMethodByRemark(MethodSignature methodSignature) {
        Method method0 = methodSignature.getMethod();
        RedisKafka rediksKafka = method0.getAnnotation(RedisKafka.class);
        return rediksKafka.notRepeat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before(value="kafkaMsgProcess()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        block7: {
            this.logger.debug("---\u6b63\u5728\u62e6\u622a---kafka---");
            Object[] obj = joinPoint.getArgs();
            KafkaMsg kafkaMsg = (KafkaMsg)obj[0];
            Lock lock = new Lock();
            try {
                Boolean notRepeat = RedisKafkaAspect.getMethodByRemark((MethodSignature)joinPoint.getSignature());
                lock.setName(kafkaMsg.getTopic() + "-lock-" + kafkaMsg.getOffset());
                lock.setValue(kafkaMsg.getMsg().toString());
                if (!this.distributedLockHandler.tryLock(lock, notRepeat.booleanValue())) break block7;
                String value = this.redisExtCommands.hget(this.redisKafkaDataBase, kafkaMsg.getTopic() + "-consumer", "" + kafkaMsg.getOffset());
                if (StringUtil.isEmpty((CharSequence)value)) {
                    this.redisExtCommands.hset(this.redisKafkaDataBase, kafkaMsg.getTopic() + "-consumer", "" + kafkaMsg.getOffset(), kafkaMsg.getMsg());
                    break block7;
                }
                this.logger.error("\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)kafkaMsg));
                throw new JkafkaException("kafka\u8fd9\u6761\u6d88\u606f\u5df2\u7ecf\u5904\u7406\u8fc7\u4e86\uff01");
            }
            catch (Exception e) {
                if (!(e instanceof JkafkaException)) {
                    this.redisExtCommands.hdel(this.redisKafkaDataBase, kafkaMsg.getTopic() + "-consumer", (Object)("" + kafkaMsg.getOffset()));
                }
            }
            finally {
                this.distributedLockHandler.releaseLock(lock);
            }
        }
    }
}

