package tech.mhuang.pacebox.springboot.wechat.wechat.common.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import tech.mhuang.pacebox.springboot.wechat.wechat.common.consts.WechatConsts;

import java.io.Serializable;
import java.util.List;

/**
 * 微信授权应答
 *
 * @author mhuang
 * @since 1.0.0
 */
@Data
public class WechatAuthAllReturn implements Serializable {

    @JSONField(name = WechatConsts.OPENID)
    @JsonProperty(value = WechatConsts.OPENID)
    private String openid;

    @JSONField(name = WechatConsts.NICKNAME)
    @JsonProperty(value = WechatConsts.NICKNAME)
    private String nickname;

    @JSONField(name = WechatConsts.SEX)
    @JsonProperty(value = WechatConsts.SEX)
    private String sex;

    @JSONField(name = WechatConsts.PROVINCE)
    @JsonProperty(value = WechatConsts.PROVINCE)
    private String province;

    @JSONField(name = WechatConsts.CITY)
    @JsonProperty(value = WechatConsts.CITY)
    private String city;

    @JSONField(name = WechatConsts.COUNTRY)
    @JsonProperty(value = WechatConsts.COUNTRY)
    private String country;

    @JSONField(name = WechatConsts.HEADIMGURL)
    @JsonProperty(value = WechatConsts.HEADIMGURL)
    private String headimgurl;

    @JSONField(name = WechatConsts.PRIVILEGE)
    @JsonProperty(value = WechatConsts.PRIVILEGE)
    private List<String> privilege;

    @JSONField(name = WechatConsts.UNIONID)
    @JsonProperty(value = WechatConsts.UNIONID)
    private String unionid;
}
