package tech.mhuang.pacebox.springboot.wechat.wechat.common.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import tech.mhuang.pacebox.springboot.wechat.wechat.common.consts.WechatConsts;

import java.io.Serializable;

/**
 * 微信授权简单回答
 *
 * @author mhuang
 * @since 1.0.0
 */
@Data
public class WechatAuthReturn implements Serializable {

    @JSONField(name = WechatConsts.SCOPE)
    @JsonProperty(value = WechatConsts.SCOPE)
    private String scope;

    @JSONField(name = WechatConsts.OPENID)
    @JsonProperty(value = WechatConsts.OPENID)
    private String openid;

    @JSONField(name = WechatConsts.ACCESS_TOKEN_FIELD)
    @JsonProperty(value = WechatConsts.ACCESS_TOKEN_FIELD)
    private String accessToken;

    @JSONField(name = WechatConsts.REFRESH_TOKEN)
    @JsonProperty(value = WechatConsts.REFRESH_TOKEN)
    private String refreshToken;

    @JSONField(name = WechatConsts.EXPIRES_IN)
    @JsonProperty(value = WechatConsts.EXPIRES_IN)
    private String expiresIn;
}
