/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.pacebox.springboot.wechat.wechat.common.service;

import java.util.Map;
import tech.mhuang.pacebox.core.util.StringUtil;
import tech.mhuang.pacebox.springboot.wechat.wechat.common.service.BaseWechatEventService;

public abstract class BaseWechatService
extends BaseWechatEventService {
    public static final String WECHAT_SUBSCRIBE = "1";
    public static final String WECHAT_UNSUBSCRIBE = "2";
    private static final String VOICE_MSG = "voice";
    private static final String VIDEO_MSG = "video";
    private static final String SHORT_VIDEO_MSG = "shiroVideo";
    private static final String LOCATION_MSG = "location";
    private static final String LINK_MSG = "link";

    public String manager(Map<String, String> wechatParamsMap) throws Exception {
        String msgType = wechatParamsMap.get("MsgType");
        if (msgType.equals("event")) {
            return this.event(wechatParamsMap);
        }
        return this.other(wechatParamsMap);
    }

    private String event(Map<String, String> map) {
        String openId = map.get("FromUserName");
        String eventType = map.get("Event");
        String appId = map.get("ToUserName");
        String eventKey = map.get("EventKey");
        switch (eventType) {
            case "subscribe": {
                if (StringUtil.isEmpty((CharSequence)eventKey)) {
                    return this.subscribe(openId, appId);
                }
                return this.subscribe(openId, appId, eventKey);
            }
            case "unsubscribe": {
                return this.unSubscribe(openId, appId);
            }
            case "CLICK": {
                return this.click(openId, appId, eventKey);
            }
            case "VIEW": {
                return this.view(openId, appId, eventKey);
            }
            case "SCAN": {
                return this.scan(openId, appId, eventKey);
            }
        }
        return null;
    }

    private String other(Map<String, String> map) {
        String msgType = map.get("MsgType");
        String appId = map.get("ToUserName");
        String openId = map.get("FromUserName");
        return switch (msgType) {
            case "text" -> this.textMsg(openId, appId, map.get("Content"));
            case "image" -> this.imageMsg(openId, appId);
            case VOICE_MSG, VIDEO_MSG, SHORT_VIDEO_MSG, LOCATION_MSG, LINK_MSG -> null;
            default -> null;
        };
    }
}

