/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.configuration;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.rsqn.useful.things.configuration.ConfigurationSource;

public abstract class AbstractConfigurationSource
implements ConfigurationSource {
    private final Logger LOG = LoggerFactory.getLogger(AbstractConfigurationSource.class);
    private String encryptedPropertyPrefix = "enc://";

    public abstract List<String> getNames();

    @Override
    public Integer getIntegerValue(String name) {
        String s = this.getStringValue(name);
        if (Strings.isNullOrEmpty((String)s)) {
            this.LOG.warn("Warning getIntegerValue {} has empty value", (Object)name);
            return null;
        }
        return Integer.valueOf(s);
    }

    @Override
    public int getIntValue(String name) {
        return this.getIntegerValue(name);
    }

    @Override
    public boolean getBoolValue(String name) {
        String s = this.getStringValue(name);
        if (Strings.isNullOrEmpty((String)s)) {
            this.LOG.warn("Warning parseBool on {} has empty value", (Object)name);
        }
        return Boolean.valueOf(s);
    }

    @Override
    public List<Integer> getIntArray(String name, String delimiter) {
        String v = this.getStringValue(name);
        if (v == null) {
            v = "";
        }
        String[] parts = v.split(delimiter);
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (String part : parts) {
            if (Strings.isNullOrEmpty((String)part)) continue;
            ret.add(Integer.parseInt(part));
        }
        return ret;
    }

    @Override
    public List<String> getStringArray(String name, String delimiter) {
        String v = this.getStringValue(name);
        if (v == null) {
            return new LinkedList<String>();
        }
        String[] parts = v.split(delimiter);
        ArrayList<String> ret = new ArrayList<String>();
        Collections.addAll(ret, parts);
        return ret;
    }

    @Override
    public int getIntValue(String name, int dfl) {
        if (!Strings.isNullOrEmpty((String)this.getStringValue(name))) {
            return Integer.parseInt(this.getStringValue(name));
        }
        return dfl;
    }

    @Override
    public Integer getIntegerValue(String name, Integer dfl) {
        if (!Strings.isNullOrEmpty((String)this.getStringValue(name))) {
            return this.getIntegerValue(name);
        }
        return dfl;
    }

    @Override
    public double getDoubleValue(String name, double dfl) {
        if (!Strings.isNullOrEmpty((String)this.getStringValue(name))) {
            return Double.valueOf(this.getStringValue(name));
        }
        return dfl;
    }

    @Override
    public boolean getBoolValue(String name, boolean dfl) {
        String v = this.getStringValue(name);
        if (!Strings.isNullOrEmpty((String)v)) {
            return this.getBoolValue(v);
        }
        return dfl;
    }

    @Override
    public boolean hasValue(String name) {
        String v = this.getStringValue(name);
        return Strings.isNullOrEmpty((String)v);
    }

    protected boolean propertyIsEncrypted(Object value) {
        return value.toString().startsWith(this.encryptedPropertyPrefix);
    }
}

