/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.configuration;

import java.util.Arrays;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import tech.rsqn.useful.things.configuration.LayeredConfigurationSource;
import tech.rsqn.useful.things.configuration.PropertiesFileConfigurationSource;
import tech.rsqn.useful.things.util.EnvVarHelper;

@Configuration
public class ConfigSourceConfig {
    private final Environment environment;

    public ConfigSourceConfig(Environment environment) {
        this.environment = environment;
    }

    @Bean(name={"envVarHelper"})
    public EnvVarHelper envVarHelper() {
        return new EnvVarHelper();
    }

    @Bean(name={"configSource"})
    public LayeredConfigurationSource configSource() {
        LayeredConfigurationSource configSource = new LayeredConfigurationSource();
        configSource.append(this.propertiesFileConfigurationSource());
        return configSource;
    }

    @Bean(name={"propertiesConfigSrc"}, initMethod="init")
    public PropertiesFileConfigurationSource propertiesFileConfigurationSource() {
        PropertiesFileConfigurationSource propertiesFileConfigSource = new PropertiesFileConfigurationSource();
        propertiesFileConfigSource.setResources(Arrays.asList("application.properties", "/common.properties", "conf/application.properties", this.environment.getProperty("env") + "/application.properties", "/etc/isignthis/application.properties", this.environment.getProperty("user.home") + "/isignthis.properties", this.configForTestRun()));
        return propertiesFileConfigSource;
    }

    private String configForTestRun() {
        this.environment.getActiveProfiles();
        if (this.environment.getActiveProfiles().length > 0 && "test".equals(this.environment.getActiveProfiles()[0])) {
            return "application-test.properties";
        }
        return "should-not-exist.skip";
    }
}

