/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.rsqn.useful.things.configuration.ConfigurationSource;

public class ConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtil.class);
    private static final char DELIMITER_DEFAULT = '.';
    private char delimiter;
    private ConfigurationSource source;

    private ConfigurationUtil(ConfigurationSource source) {
        this.source = source;
        this.delimiter = (char)46;
    }

    public static ConfigurationUtil using(ConfigurationSource source) {
        return new ConfigurationUtil(source);
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean getBoolValue(String key) {
        return this.source.getBoolValue(key);
    }

    public boolean getBoolValue(String key, String client) {
        String apiClientOverrideKey = key + this.delimiter + client;
        if (StringUtils.isEmpty((CharSequence)client) || this.source.getStringValue(apiClientOverrideKey) == null) {
            return this.getBoolValue(key);
        }
        return this.source.getBoolValue(apiClientOverrideKey);
    }

    public boolean getBoolValue(String key, String client, String merchant) {
        String merchantKey = key + this.delimiter + client + this.delimiter + merchant;
        if (StringUtils.isEmpty((CharSequence)merchant) || this.source.getStringValue(merchantKey) == null) {
            return this.getBoolValue(key, client);
        }
        return this.source.getBoolValue(merchantKey);
    }

    public boolean getBoolValue(String key, String client, String merchant, String currency) {
        String currencyKey = key + this.delimiter + client + this.delimiter + merchant + this.delimiter + currency;
        if (StringUtils.isEmpty((CharSequence)currency) || this.source.getStringValue(currencyKey) == null) {
            return this.getBoolValue(key, client, merchant);
        }
        return this.source.getBoolValue(currencyKey);
    }

    public Integer getIntegerValue(String key) {
        return this.source.getIntegerValue(key);
    }

    public Integer getIntegerValue(String key, String client) {
        if (StringUtils.isEmpty((CharSequence)client)) {
            return this.getIntegerValue(key);
        }
        Integer value = this.source.getIntegerValue(key + this.delimiter + client);
        return value == null ? this.getIntegerValue(key) : value;
    }

    public Integer getIntegerValue(String key, String client, String merchant) {
        if (StringUtils.isEmpty((CharSequence)merchant)) {
            return this.getIntegerValue(key, client);
        }
        Integer value = this.source.getIntegerValue(key + this.delimiter + client + this.delimiter + merchant);
        return value == null ? this.getIntegerValue(key, client) : value;
    }

    public Integer getIntegerValue(String key, String client, String merchant, String currency) {
        if (StringUtils.isEmpty((CharSequence)currency)) {
            return this.getIntegerValue(key, client, merchant);
        }
        Integer value = this.source.getIntegerValue(key + this.delimiter + client + this.delimiter + merchant + this.delimiter + currency);
        return value == null ? this.getIntegerValue(key, client, merchant) : value;
    }

    public String getStringValue(String key) {
        return this.source.getStringValue(key);
    }

    public String getStringValue(String key, String client) {
        if (StringUtils.isEmpty((CharSequence)client)) {
            return this.getStringValue(key);
        }
        String value = this.source.getStringValue(key + this.delimiter + client);
        return value == null ? this.getStringValue(key) : value;
    }

    public String getStringValue(String key, String client, String merchant) {
        if (StringUtils.isEmpty((CharSequence)merchant)) {
            return this.getStringValue(key, client);
        }
        String value = this.source.getStringValue(key + this.delimiter + client + this.delimiter + merchant);
        return value == null ? this.getStringValue(key, client) : value;
    }

    public String getStringValue(String key, String client, String merchant, String currency) {
        if (StringUtils.isEmpty((CharSequence)currency)) {
            return this.getStringValue(key, client, merchant);
        }
        String value = this.source.getStringValue(key + this.delimiter + client + this.delimiter + merchant + this.delimiter + currency);
        return value == null ? this.getStringValue(key, client, merchant) : value;
    }

    public String getStringValueDynamic(String key, String client, List<String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return this.getStringValue(key, client);
        }
        for (String par : parameters) {
            String res = this.source.getStringValue(key + this.delimiter + client + this.delimiter + par);
            if (res == null) continue;
            logger.debug("property resolved for: {" + key + this.delimiter + client + this.delimiter + par + "}");
            return res;
        }
        return this.getStringValue(key, client);
    }

    public List<String> getStringArrayValue(String key, String arrayDelimiter) {
        return this.source.getStringArray(key, arrayDelimiter);
    }

    public List<String> getStringArrayValue(String key, String arrayDelimiter, String client) {
        String thisKey = key + this.delimiter + client;
        if (StringUtils.isEmpty((CharSequence)client) || this.source.getStringValue(thisKey) == null) {
            return this.getStringArrayValue(key, arrayDelimiter);
        }
        return this.source.getStringArray(thisKey, arrayDelimiter);
    }

    public List<String> getStringArrayValue(String key, String arrayDelimiter, String client, String merchant) {
        String thisKey = key + this.delimiter + client + this.delimiter + merchant;
        if (StringUtils.isEmpty((CharSequence)merchant) || this.source.getStringValue(thisKey) == null) {
            return this.getStringArrayValue(key, arrayDelimiter, client);
        }
        return this.source.getStringArray(thisKey, arrayDelimiter);
    }

    public List<String> getStringArrayValue(String key, String arrayDelimiter, String client, String merchant, String currency) {
        String thisKey = key + this.delimiter + client + this.delimiter + merchant + this.delimiter + currency;
        if (StringUtils.isEmpty((CharSequence)currency) || this.source.getStringValue(thisKey) == null) {
            return this.getStringArrayValue(key, arrayDelimiter, client, merchant);
        }
        return this.source.getStringArray(thisKey, arrayDelimiter);
    }

    public List<String> getRoutingCombinations(List<String> input) {
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<String> input_copy = new ArrayList<String>(input);
        for (int i = 0; i < input.size(); ++i) {
            String pivot = input.get(i);
            input_copy.remove(pivot);
            results.addAll(this.generateRoutingCombinations(pivot, input_copy));
            input_copy = new ArrayList<String>(input);
        }
        return results;
    }

    private List<String> generateRoutingCombinations(String pivot, List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> validPermutations = this.generateValidPermutations(list);
        result.add(pivot);
        for (String validPermutation : validPermutations) {
            result.add(pivot + String.valueOf(this.delimiter) + validPermutation);
        }
        Collections.reverse(result);
        return result;
    }

    private List<String> generateValidPermutations(List<String> input) {
        String[] buff = new String[input.size()];
        LinkedHashSet<String> resultList = new LinkedHashSet<String>();
        int input_size = input.size();
        for (int i = 1; i <= input_size; ++i) {
            this.permutationGenerator(input, 0, i, buff, resultList);
        }
        return new ArrayList<String>(resultList);
    }

    private void permutationGenerator(List<String> input, int i, int k, String[] buff, LinkedHashSet<String> resultList) {
        if (i < k) {
            for (int j = input.size() - 1; j >= 0; --j) {
                buff[i] = input.get(j);
                this.permutationGenerator(input, i + 1, k, buff, resultList);
            }
        } else {
            LinkedHashSet<String> resList = new LinkedHashSet<String>();
            for (String str : buff) {
                if (str == null) continue;
                resList.add(str);
            }
            resultList.add(String.join((CharSequence)String.valueOf(this.delimiter), resList));
        }
    }
}

