/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import tech.rsqn.useful.things.configuration.AbstractConfigurationSource;
import tech.rsqn.useful.things.configuration.ConfigurationSource;

public class LayeredConfigurationSource
extends AbstractConfigurationSource {
    private List<ConfigurationSource> layers = new CopyOnWriteArrayList<ConfigurationSource>();

    public void append(ConfigurationSource src) {
        this.layers.add(src);
    }

    @Override
    public String getEnvironment() {
        return System.getProperty("env");
    }

    @Override
    public String getStringValue(String name) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            ConfigurationSource layer = this.layers.get(i);
            if (!layer.hasValue(name)) continue;
            return layer.getStringValue(name);
        }
        return null;
    }

    @Override
    public String getStringValue(String name, String dfl) {
        String ret = this.getStringValue(name);
        if (StringUtils.isEmpty((CharSequence)ret)) {
            ret = dfl;
        }
        return ret;
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (ConfigurationSource layer : this.layers) {
            ret.putAll(layer.asMap());
        }
        return ret;
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (ConfigurationSource layer : this.layers) {
            for (String key : layer.asMap().keySet()) {
                if (ret.contains(key)) continue;
                ret.add(key);
            }
        }
        return ret;
    }

    @Override
    public void setValue(String name, String value) {
        throw new NotImplementedException("setValue not implemented - " + name);
    }
}

