/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.configuration;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import tech.rsqn.useful.things.configuration.AbstractConfigurationSource;
import tech.rsqn.useful.things.configuration.ConfigurationRuntimeException;

public class PropertiesFileConfigurationSource
extends AbstractConfigurationSource {
    private Map<String, String> used = new ConcurrentHashMap<String, String>();
    Logger log = LoggerFactory.getLogger(PropertiesFileConfigurationSource.class);
    Properties myProps;
    private List<String> resources = new ArrayList<String>();

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    @Override
    public String getEnvironment() {
        return System.getProperty("env");
    }

    public PropertiesFileConfigurationSource(String name) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(name);
        this.init();
    }

    public PropertiesFileConfigurationSource() {
    }

    private void reportOnProperties() {
        ArrayList<String> notUsed = new ArrayList<String>();
        for (Object o : this.myProps.keySet()) {
            String k = (String)o;
            if (this.used.containsKey(k)) continue;
            notUsed.add(k);
        }
        for (String k : this.used.keySet()) {
            this.log.info("PROPERTY IS USED: " + k);
        }
        for (String k : notUsed) {
            this.log.warn("PROPERTY IS NOT USED: " + k);
        }
    }

    public void init() {
        try {
            this.myProps = new Properties();
            int ctr = 0;
            for (String rn : this.resources) {
                this.loadResource(rn, ctr == 0);
                ++ctr;
            }
        }
        catch (Exception ex) {
            this.log.error("Exception loading properties " + ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private void loadResource(String name, boolean throwErrorIfNotFound) {
        ClassPathResource resource = new ClassPathResource(this.getEnvironment() + "/" + name);
        if (!resource.exists()) {
            resource = new ClassPathResource(name);
        }
        if (!resource.exists()) {
            if (throwErrorIfNotFound) {
                throw new RuntimeException("Resource " + name + " was not found");
            }
            this.log.warn("Resource " + name + " does not exist in classpath - checking file system");
            File f = new File(name);
            if (!f.exists()) {
                this.log.warn("Resource " + name + " does not exist in classpath or filesystem - bypassing");
                return;
            }
            this.log.warn("Resource " + name + " was found on filesystem");
            resource = new FileSystemResource(f);
        } else {
            this.log.warn("Resource " + name + " was found in classpath");
        }
        this.log.info("Loading properties from " + resource.getFilename());
        Properties properties = new Properties();
        try {
            InputStreamReader unicodeIsr = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
            properties.load(unicodeIsr);
            for (Object o : properties.keySet()) {
                String k = o.toString();
                if (this.myProps.get(o) != null) {
                    this.log.info("OVERRIDE property " + k + " from " + name);
                } else {
                    this.log.info("SET property " + k + " from " + name);
                }
                this.myProps.put(k, properties.get(o));
                if (k.startsWith("sysprop.")) {
                    String n = k.substring(8);
                    this.log.info("SET SYSPROP " + n + " from " + k);
                    System.setProperty(n, this.myProps.getProperty(k));
                }
                Object value = properties.get(o);
                this.myProps.put(o, value);
            }
        }
        catch (IOException e) {
            throw new ConfigurationRuntimeException(e);
        }
    }

    public static PropertiesFileConfigurationSource withClassPathResource(String name) {
        PropertiesFileConfigurationSource ret = new PropertiesFileConfigurationSource(name);
        return ret;
    }

    @Override
    public String getStringValue(String name) {
        this.used.put(name, name);
        return this.myProps.getProperty(name);
    }

    @Override
    public String getStringValue(String name, String dfl) {
        this.used.put(name, name);
        String ret = this.myProps.getProperty(name);
        if (Strings.isNullOrEmpty((String)ret)) {
            ret = dfl;
        }
        return ret;
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Object o : this.myProps.keySet()) {
            ret.put((String)o, this.myProps.getProperty((String)o));
        }
        return ret;
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.myProps.stringPropertyNames());
        return ret;
    }

    @Override
    public void setValue(String name, String value) {
        this.myProps.put(name, value);
    }
}

