/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.encryption;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import tech.rsqn.useful.things.encryption.DecryptException;
import tech.rsqn.useful.things.encryption.EncryptionTool;
import tech.rsqn.useful.things.encryption.KeyRollRequiredException;
import tech.rsqn.useful.things.encryption.RSAEncryptionTool;
import tech.rsqn.useful.things.encryption.UnableToDecryptException;

public class KeyRollingRSAEncryptionTool
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(KeyRollingRSAEncryptionTool.class);
    private Map<String, EncryptionTool> tools = new HashMap<String, EncryptionTool>();
    private String currentAlias;
    private List<EncryptionTool> nonCurrent = new ArrayList<EncryptionTool>();

    public Map<String, EncryptionTool> getTools() {
        return this.tools;
    }

    public void setTools(Map<String, EncryptionTool> tools) {
        this.tools = tools;
    }

    public String getCurrentAlias() {
        return this.currentAlias;
    }

    public void setCurrentAlias(String currentAlias) {
        this.currentAlias = currentAlias;
    }

    public EncryptionTool getCurrent() {
        return this.tools.get(this.currentAlias);
    }

    public EncryptionTool getForAlias(String alias) {
        return this.tools.get(alias);
    }

    public void addTool(String alias, RSAEncryptionTool t) {
        this.tools.put(alias, t);
    }

    public byte[] encrypt(byte[] plainText) {
        return this.getCurrent().encrypt(plainText);
    }

    public byte[] decrypt(byte[] cryptText) {
        try {
            return this.getCurrent().decrypt(cryptText);
        }
        catch (DecryptException bbe) {
            throw new KeyRollRequiredException(bbe.getMessage());
        }
    }

    public String encode(String plainText) {
        return this.getCurrent().encode(plainText);
    }

    public String decode(String encodedText) {
        try {
            return this.getCurrent().decode(encodedText);
        }
        catch (DecryptException bbe) {
            throw new KeyRollRequiredException(bbe.getMessage());
        }
    }

    public String decodeAutoSelect(String encodedText) {
        for (String alias : this.tools.keySet()) {
            try {
                return this.getForAlias(alias).decode(encodedText);
            }
            catch (Exception ex) {
                log.info("Unable to decode with alias " + alias + " " + ex.getMessage());
            }
        }
        throw new UnableToDecryptException();
    }

    public byte[] decryptAutoSelect(byte[] cryptText) {
        for (String alias : this.tools.keySet()) {
            try {
                return this.getForAlias(alias).decrypt(cryptText);
            }
            catch (Exception ex) {
                log.info("Unable to decode with alias " + alias + " " + ex.getMessage());
            }
        }
        throw new UnableToDecryptException();
    }

    public byte[] encrypt(String alias, byte[] plainText) {
        return this.getForAlias(alias).encrypt(plainText);
    }

    public byte[] decrypt(String alias, byte[] cryptText) {
        return this.getForAlias(alias).decrypt(cryptText);
    }

    public String encode(String alias, String plainText) {
        return this.getForAlias(alias).encode(plainText);
    }

    public String decode(String alias, String encodedText) {
        return this.getForAlias(alias).decode(encodedText);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.tools.get(this.currentAlias) == null) {
            throw new RuntimeException("No key with alias " + this.currentAlias + " found");
        }
        for (String s : this.tools.keySet()) {
            if (s.equals(this.currentAlias)) continue;
            this.nonCurrent.add(this.tools.get(s));
        }
    }
}

