/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.encryption;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtil;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import tech.rsqn.useful.things.encryption.DecryptException;
import tech.rsqn.useful.things.encryption.EncryptionTool;
import tech.rsqn.useful.things.encryption.PemFile;

public class RSAEncryptionTool
implements EncryptionTool,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RSAEncryptionTool.class);
    private String charSet = "utf-8";
    private String privateKeyFile;
    private String privateKeyPassword;
    private String publicKeyFile;
    private String algorithm = "RSA/NONE/OAEPPadding";
    private String provider = "BC";
    private AmazonS3 s3Client;
    private KeyFactory factory;
    private String keyDir;
    private File _keyDir;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private String alias;
    private static final String CLASS_PATH_PREFIX = "classpath://";
    private static final String S3_PATH_PREFIX = "s3://";
    private Map<String, String> quickState = new HashMap<String, String>();

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setKeyDir(String keyDir) {
        this.keyDir = keyDir;
    }

    public void setS3Client(AmazonS3 s3Client) {
        this.s3Client = s3Client;
    }

    public void setPublicKeyFile(String publicKeyFile) {
        this.publicKeyFile = publicKeyFile;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public RSAEncryptionTool() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void afterPropertiesSet() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.factory = KeyFactory.getInstance("RSA", "BC");
        this._keyDir = new File(this.keyDir);
        log.info("RSAEncryptionTool - Private Key Path " + this.privateKeyFile);
        log.info("RSAEncryptionTool - Private Key Password Present ? " + StringUtils.isNotEmpty((CharSequence)this.privateKeyPassword));
        log.info("RSAEncryptionTool - Public Key Path " + this.publicKeyFile);
        log.info("RSAEncryptionTool - keyDir " + this._keyDir.getAbsolutePath());
        if (!this._keyDir.exists()) {
            this._keyDir.mkdirs();
        }
        if (!StringUtils.isEmpty((CharSequence)this.privateKeyFile)) {
            this.privateKey = this.loadPrivateKey(this.privateKeyFile, this.privateKeyPassword);
        }
        this.publicKey = this.loadPublicKey(this.publicKeyFile);
    }

    @Override
    public byte[] encrypt(byte[] plainText) {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm, this.provider);
            cipher.init(1, this.publicKey);
            return cipher.doFinal(plainText);
        }
        catch (Exception e) {
            throw new RuntimeException("Decryption exception " + e, e);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptText) {
        if (StringUtils.isEmpty((CharSequence)this.privateKeyFile)) {
            throw new RuntimeException("Private key not available for decryption");
        }
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm, this.provider);
            cipher.init(2, this.privateKey);
            return cipher.doFinal(cryptText);
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption exception " + e, e);
        }
    }

    @Override
    public String encode(String plainText) {
        try {
            byte[] encData = this.encrypt(plainText.getBytes(this.charSet));
            return new String(Base64.encodeBase64((byte[])encData), this.charSet);
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption exception " + e, e);
        }
    }

    @Override
    public String decode(String encodedText) {
        try {
            byte[] fromHex = Base64.decodeBase64((String)encodedText);
            byte[] decData = this.decrypt(fromHex);
            return new String(decData, this.charSet);
        }
        catch (Exception e) {
            throw new DecryptException("Decryption exception " + e, e);
        }
    }

    @Override
    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public KeyPair fetchKeyPair() {
        KeyPair ret = new KeyPair(this.publicKey, this.privateKey);
        return ret;
    }

    private String fetchRemoteIfNecessary(String s) {
        if (s.startsWith("s3")) {
            String string;
            block6: {
                String[] bucketAndKey = this.parseBucketKeyAndFileName(s);
                String bucket = bucketAndKey[0];
                String key = bucketAndKey[1];
                String fileName = bucketAndKey[2];
                log.info("KeyTool - fetching " + s);
                S3Object obj = this.s3Client.getObject(bucket, key);
                log.info("KeyTool - fetched " + s);
                this.quickState.put(s, "fetched");
                File f = new File(this._keyDir, fileName);
                FileOutputStream os = null;
                log.info("KeyTool - output file " + f.getAbsolutePath());
                try {
                    S3ObjectInputStream is = obj.getObjectContent();
                    log.info("KeyTool - fetching " + s);
                    os = new FileOutputStream(f);
                    IOUtil.copy((InputStream)is, (OutputStream)os);
                    log.info("local path now " + f.getAbsolutePath());
                    string = f.getAbsolutePath();
                    if (os == null) break block6;
                }
                catch (Exception ex) {
                    try {
                        log.info("KeyTool - failed to write to " + f.getAbsolutePath());
                        throw new RuntimeException(ex);
                    }
                    catch (Throwable throwable) {
                        if (os != null) {
                            IOUtil.shutdownStream(os);
                        }
                        throw throwable;
                    }
                }
                IOUtil.shutdownStream((OutputStream)os);
            }
            return string;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PrivateKey loadPrivateKey(String fileName, String keyPass) throws Exception {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(this.provider);
        PrivateKey privateKey = null;
        try (Reader keyReader = null;){
            if (fileName.startsWith(CLASS_PATH_PREFIX)) {
                String keyResource = fileName.substring(CLASS_PATH_PREFIX.length());
                keyReader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(keyResource));
            } else if (fileName.startsWith(S3_PATH_PREFIX)) {
                String fn = this.fetchRemoteIfNecessary(fileName);
                keyReader = new FileReader(fn);
            } else {
                keyReader = new FileReader(fileName);
            }
            PEMParser pemParser = new PEMParser(keyReader);
            Object key = pemParser.readObject();
            if (key instanceof PEMEncryptedKeyPair) {
                if (keyPass == null) throw new RuntimeException("Encrypted private key found but no pass provided");
                PEMDecryptorProvider decryptionProvider = new JcePEMDecryptorProviderBuilder().build(keyPass.toCharArray());
                privateKey = converter.getKeyPair(((PEMEncryptedKeyPair)key).decryptKeyPair(decryptionProvider)).getPrivate();
                return privateKey;
            } else {
                privateKey = converter.getKeyPair((PEMKeyPair)key).getPrivate();
            }
            return privateKey;
        }
    }

    public PublicKey loadPublicKey(String fileName) {
        try {
            fileName = this.fetchRemoteIfNecessary(fileName);
            PemFile pemFile = new PemFile().with(fileName);
            byte[] content = pemFile.getPemObject().getContent();
            X509EncodedKeySpec spec = new X509EncodedKeySpec(content);
            return this.factory.generatePublic(spec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String[] parseBucketKeyAndFileName(String s) {
        String[] ret = new String[3];
        s = s.substring(S3_PATH_PREFIX.length());
        int index = s.indexOf("/");
        String bucket = s.substring(0, index);
        String key = s.substring(index + 1);
        String fn = s.substring(s.lastIndexOf("/") + 1);
        ret[0] = bucket;
        ret[1] = key;
        ret[2] = fn;
        return ret;
    }
}

