/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.systems;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClient;
import org.springframework.beans.factory.InitializingBean;

public class AWSClientFactory
implements InitializingBean {
    private String accessKey;
    private String secretKey;
    private String region;

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public AmazonS3Client s3Client() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        AmazonS3Client client = new AmazonS3Client((AWSCredentials)credentials);
        return client;
    }

    public AWSSimpleSystemsManagementClient systemsManagementClient() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        AWSSimpleSystemsManagementClient client = new AWSSimpleSystemsManagementClient((AWSCredentials)credentials);
        client.setRegion(RegionUtils.getRegion((String)this.region));
        return client;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

