/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.systems;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClient;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersResult;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class AWSSystemsManagerPropertiesProvider
implements InitializingBean {
    private Logger log = LoggerFactory.getLogger(AWSSystemsManagerPropertiesProvider.class);
    private AWSSimpleSystemsManagementClient ssmClient;
    private String parameterPrefix = "";
    private boolean logParameterValues = false;
    private Map<String, String> allProperties = new HashMap<String, String>();
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private List<String> resolvedProperties = new ArrayList<String>();
    private List<String> names = new ArrayList<String>();

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setLogParameterValues(boolean logParameterValues) {
        this.logParameterValues = logParameterValues;
    }

    public void setParameterPrefix(String parameterPrefix) {
        this.parameterPrefix = parameterPrefix;
    }

    public void setSsmClient(AWSSimpleSystemsManagementClient ssmClient) {
        this.ssmClient = ssmClient;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public void resolveAllParameters() {
        ArrayList<Object> allNames = new ArrayList<Object>();
        for (String string : this.names) {
            allNames.add(string);
            if (com.amazonaws.util.StringUtils.isNullOrEmpty((String)this.parameterPrefix)) continue;
            String string2 = this.parameterPrefix + string;
            allNames.add(string2);
        }
        Iterable partitions = Iterables.partition(allNames, (int)10);
        for (List partition : partitions) {
            GetParametersRequest request = new GetParametersRequest();
            List filtered = partition.stream().filter(k -> {
                if (k.startsWith("aws.")) {
                    this.log.warn("Will not try to resolve unprefixed key (" + k + ") - AWS does not allow this");
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            request.setNames(filtered);
            request.setWithDecryption(Boolean.valueOf(true));
            GetParametersResult result = this.ssmClient.getParameters(request);
            for (Parameter parameter : result.getParameters()) {
                String n = parameter.getName();
                String v = parameter.getValue();
                if (!com.amazonaws.util.StringUtils.isNullOrEmpty((String)this.parameterPrefix) && n.startsWith(this.parameterPrefix)) {
                    this.log.info("removing environment prefix " + this.parameterPrefix + " from parameter name " + n);
                    n = n.substring(this.parameterPrefix.length());
                }
                String logValue = "########";
                if (this.logParameterValues) {
                    logValue = v;
                }
                this.log.info("Parameter (" + n + ") = (" + logValue + ") in spring context ");
                this.allProperties.put(n, v);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String forceResolve(String key) {
        GetParametersRequest request;
        if (key.startsWith("aws.")) {
            this.log.warn("Will not try to resolve unprefixed key (" + key + ") - AWS does not allow this");
            if (!StringUtils.isNotEmpty((CharSequence)this.parameterPrefix)) return null;
            request = new GetParametersRequest().withNames(new String[]{this.parameterPrefix + key}).withWithDecryption(Boolean.valueOf(true));
        } else {
            request = new GetParametersRequest().withNames(new String[]{this.parameterPrefix + key, key}).withWithDecryption(Boolean.valueOf(true));
        }
        GetParametersResult result = this.ssmClient.getParameters(request);
        Iterator iterator = result.getParameters().iterator();
        if (!iterator.hasNext()) return null;
        Parameter parameter = (Parameter)iterator.next();
        return parameter.getValue();
    }

    public String resolve(String key) {
        String v = this.allProperties.get(key);
        if (v == null && !this.resolvedProperties.contains(key)) {
            v = this.forceResolve(key);
            if (v != null) {
                this.allProperties.put(key, v);
            }
            this.resolvedProperties.add(key);
        }
        if (StringUtils.isEmpty((CharSequence)v)) {
            v = this.defaultProperties.get(key);
            if (StringUtils.isEmpty((CharSequence)v)) {
                this.log.info("Parameter resolving (" + key + ") - no value or default present ");
            } else {
                this.log.info("Parameter (" + key + ") - default used ");
            }
        } else {
            this.log.info("Parameter resolved (" + key + ") present ? " + StringUtils.isNotEmpty((CharSequence)v));
        }
        if (StringUtils.isNotEmpty((CharSequence)v) && v.startsWith("${")) {
            this.log.info("Parameter null for (" + key + ") as it appears to be an unresolved placeholder");
            v = null;
        } else {
            this.log.info("Parameter (" + key + ") passed placeholder filter");
        }
        return v;
    }

    public String resolve(String key, String _default) {
        String v = this.allProperties.get(key);
        if (StringUtils.isEmpty((CharSequence)v)) {
            v = _default;
            this.log.info("Resolving parameter (" + key + ") - default used ");
        } else {
            this.log.info("Resolving parameter (" + key + ") present ? " + StringUtils.isNotEmpty((CharSequence)v));
        }
        return v;
    }

    public void afterPropertiesSet() throws Exception {
        this.resolveAllParameters();
    }
}

