/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EnvVarHelper {
    private static final Pattern ENV_VAR_PATTERN = Pattern.compile("\\$\\{([A-Za-z0-9_.-]+)(?::([^\\}]*))?\\}");

    public static String substituteEnvVars(String text) {
        return EnvVarHelper.substituteEnvVars(text, System.getenv());
    }

    public static String substituteEnvVars(String text, Map<String, ?> replaceMap) {
        if (StringUtils.isBlank((CharSequence)text) || replaceMap == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Matcher matcher = ENV_VAR_PATTERN.matcher(text);
        int index = 0;
        while (matcher.find()) {
            String value;
            sb.append(text, index, matcher.start());
            String var = matcher.group(1);
            Object obj = replaceMap.get(var);
            if (obj != null) {
                value = String.valueOf(obj);
            } else {
                value = matcher.group(2);
                if (value == null) {
                    value = "";
                }
            }
            sb.append(value);
            index = matcher.end();
        }
        sb.append(text, index, text.length());
        return sb.toString();
    }
}

