/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import tech.rsqn.useful.things.lambda.LambdaSpringUtil;
import tech.rsqn.useful.things.lambda.model.ApiGatewayResponse;

public abstract class AbstractLambdaSpringService<C, R>
implements RequestHandler<APIGatewayProxyRequestEvent, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLambdaSpringService.class);

    protected void wire(Object o) {
        LambdaSpringUtil.wireInSpring(o, o.getClass().getSimpleName());
    }

    public abstract R handleRequest(APIGatewayProxyRequestEvent var1, C var2, Context var3);

    public abstract Class getModelClass();

    public R handleRequest(APIGatewayProxyRequestEvent proxyEvent, Context context) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)new ISO8601DateFormat());
        Object model = null;
        try {
            LOG.debug("ProxyRequest " + proxyEvent.toString());
            if (proxyEvent.getHeaders() == null && proxyEvent.getHttpMethod() == null) {
                LOG.debug("v2 This seems to be a keepalive. returning");
                return null;
            }
            if ("GET".equals(proxyEvent.getHttpMethod()) && proxyEvent.getQueryStringParameters() != null && "true".equals(proxyEvent.getQueryStringParameters().get("ping"))) {
                LOG.debug("v2 This seems to be a ping. returning an OK");
                return (R)ApiGatewayResponse.builder().withNoCache().setStatusCode(HttpStatus.OK.value()).setRawBody(new Date().toString()).build();
            }
            if (proxyEvent.getBody() != null && proxyEvent.getBody().length() > 0) {
                model = objectMapper.readValue(proxyEvent.getBody(), this.getModelClass());
            }
            return this.handleRequest(proxyEvent, model, context);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

