/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.lambda;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class LambdaSpringUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LambdaSpringUtil.class);
    private static Object lck = new Object();
    private static String globalRootContextPath = "/spring/app-ctx.xml";
    private static ApplicationContext ctx = null;

    @Autowired
    public void setCtx(ApplicationContext _ctx) {
        if (ctx == null) {
            ctx = _ctx;
        }
    }

    public static void setGlobalRootContextPath(String s) {
        globalRootContextPath = s;
    }

    public static ApplicationContext getCtx() {
        return ctx;
    }

    public static void wireInSpring(Object o) {
        LambdaSpringUtil.wireInSpring(o, o.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wireInSpring(Object o, String myBeanName) {
        if (ctx == null) {
            Object object = lck;
            synchronized (object) {
                if (ctx == null) {
                    LOG.info("LamdaSpringUtil CTX is null -  initialising spring");
                    ctx = new ClassPathXmlApplicationContext(globalRootContextPath);
                }
            }
        } else {
            LOG.debug("LamdaSpringUtil CTX is not null - not initialising spring");
        }
        AutowireCapableBeanFactory factory = ctx.getAutowireCapableBeanFactory();
        factory.autowireBean(o);
        factory.initializeBean((Object)0, myBeanName);
    }
}

